/*
 * Decompiled with CFR 0.152.
 */
package fr.marcwrobel.jbanking.calendar;

import fr.marcwrobel.jbanking.calendar.Calendar;
import fr.marcwrobel.jbanking.calendar.Holiday;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class CompositeCalendar
implements Calendar {
    private final List<Calendar> calendars;

    public CompositeCalendar(Collection<Calendar> calendars) {
        if (calendars.isEmpty()) {
            throw new IllegalArgumentException("calendars must not be empty");
        }
        this.calendars = new ArrayList<Calendar>(calendars);
    }

    public CompositeCalendar(Calendar ... calendars) {
        this(Arrays.asList(calendars));
    }

    @Override
    public boolean isHoliday(LocalDate date) {
        for (Calendar calendar : this.calendars) {
            if (!calendar.isHoliday(date)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Holiday> getHolidaysFor(LocalDate date) {
        HashSet<Holiday> matchingHolidays = new HashSet<Holiday>(0);
        for (Calendar calendar : this.calendars) {
            matchingHolidays.addAll(calendar.getHolidaysFor(date));
        }
        return matchingHolidays;
    }
}

