/*
 * Decompiled with CFR 0.152.
 */
package fr.marcwrobel.jbanking.calendar;

import fr.marcwrobel.jbanking.calendar.Holiday;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.Month;
import java.time.temporal.TemporalAdjusters;
import java.util.Objects;

public final class DayOfWeekInMonthHoliday
implements Holiday {
    private final int weekNumber;
    private final DayOfWeek dayOfWeek;
    private final Month month;

    public DayOfWeekInMonthHoliday(int weekNumber, DayOfWeek dayOfWeek, Month month) {
        this.weekNumber = weekNumber;
        this.dayOfWeek = Objects.requireNonNull(dayOfWeek);
        this.month = Objects.requireNonNull(month);
    }

    @Override
    public boolean check(LocalDate date) {
        LocalDate dateForYear = this.dateForYear(date.getYear());
        return dateForYear.equals(date);
    }

    private LocalDate dateForYear(int year) {
        return LocalDate.of(year, this.month, 1).with(TemporalAdjusters.dayOfWeekInMonth(this.weekNumber, this.dayOfWeek));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DayOfWeekInMonthHoliday that = (DayOfWeekInMonthHoliday)o;
        return this.weekNumber == that.weekNumber && this.dayOfWeek == that.dayOfWeek && this.month == that.month;
    }

    public int hashCode() {
        return Objects.hash(this.weekNumber, this.dayOfWeek, this.month);
    }

    public String toString() {
        return "DayOfWeekInMonthHoliday{weekNumber=" + this.weekNumber + ", dayOfWeek=" + this.dayOfWeek + ", month=" + this.month + '}';
    }
}

