/*
 * Decompiled with CFR 0.152.
 */
package fr.marcwrobel.jbanking.checkdigit;

import fr.marcwrobel.jbanking.checkdigit.CheckDigit;

public enum IbanCheckDigit implements CheckDigit
{
    INSTANCE;

    private static final int BBAN_INDEX = 4;
    private static final long CHECK_DIGITS_MAX = 999999999L;
    private static final long CHECK_DIGITS_MODULUS = 97L;
    private static final int CHECK_DIGITS_REMAINDER = 1;

    @Override
    public boolean validate(String iban) {
        if (iban == null || iban.length() <= 4) {
            return false;
        }
        char firstChar = iban.charAt(2);
        char secondChar = iban.charAt(3);
        if (firstChar == '0' && (secondChar == '0' || secondChar == '1') || firstChar == '9' && secondChar == '9') {
            return false;
        }
        return this.modulus(iban) == 1;
    }

    @Override
    public String calculate(String iban) {
        if (iban == null) {
            throw new IllegalArgumentException("the iban argument cannot be null");
        }
        if (iban.length() <= 4) {
            throw new IllegalArgumentException("the iban argument size must be greater than 4");
        }
        int modulusResult = this.modulus(iban);
        int charValue = 98 - modulusResult;
        String checkDigit = Integer.toString(charValue);
        return charValue > 9 ? checkDigit : "0" + checkDigit;
    }

    private int modulus(String iban) {
        String reformattedIban = iban.substring(4) + iban.substring(0, 4);
        long total = 0L;
        for (int i = 0; i < reformattedIban.length(); ++i) {
            int charValue = Character.digit(reformattedIban.charAt(i), 36);
            total = (charValue > 9 ? total * 100L : total * 10L) + (long)charValue;
            if (total <= 999999999L) continue;
            total %= 97L;
        }
        return (int)(total % 97L);
    }
}

