/*
 * Decompiled with CFR 0.152.
 */
package fr.marcwrobel.jbanking.creditor;

import fr.marcwrobel.jbanking.IsoCountry;
import fr.marcwrobel.jbanking.checkdigit.IbanCheckDigit;
import fr.marcwrobel.jbanking.creditor.CreditorIdentifierFormatException;
import fr.marcwrobel.jbanking.internal.AsciiCharacters;
import fr.marcwrobel.jbanking.internal.Normalizer;
import java.io.Serializable;
import java.util.Optional;

public final class CreditorIdentifier
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String REGEX = "\\s*[a-zA-Z]{2}[0-9]{2}[a-zA-Z0-9]{3}[a-zA-Z0-9]+\\s*";
    private static final int MIN_LENGTH = 8;
    private static final int COUNTRY_CODE_INDEX = 0;
    private static final int COUNTRY_CODE_LENGTH = 2;
    private static final int CHECK_DIGITS_INDEX = 2;
    private static final int CHECK_DIGITS_LENGTH = 2;
    private static final int CREDITOR_BUSINESS_CODE_INDEX = 4;
    private static final int CREDITOR_BUSINESS_CODE_LENGTH = 3;
    private static final int CREDITOR_NATIONAL_ID_INDEX = 7;
    private final String value;

    public CreditorIdentifier(String s) {
        if (s == null) {
            throw new IllegalArgumentException("s cannot be null");
        }
        String normalized = Normalizer.trimUpperCase(s);
        if (!CreditorIdentifier.isWellFormatted(normalized)) {
            throw CreditorIdentifierFormatException.forNotProperlyFormattedInput(s);
        }
        Optional<IsoCountry> country = CreditorIdentifier.findCountryFor(normalized);
        if (!country.isPresent()) {
            throw CreditorIdentifierFormatException.forUnknownCountry(s);
        }
        String normalizedWithoutBusinessCode = CreditorIdentifier.removeBusinessCode(normalized);
        if (!IbanCheckDigit.INSTANCE.validate(normalizedWithoutBusinessCode)) {
            throw CreditorIdentifierFormatException.forIncorrectCheckDigits(s);
        }
        this.value = normalized;
    }

    public CreditorIdentifier(IsoCountry country, String businessCode, String nationalId) {
        if (country == null) {
            throw new IllegalArgumentException("country cannot be null");
        }
        if (businessCode == null) {
            throw new IllegalArgumentException("businessCode cannot be null");
        }
        if (nationalId == null) {
            throw new IllegalArgumentException("nationalId cannot be null");
        }
        String normalizedBusinessCode = Normalizer.trimUpperCase(businessCode);
        String normalizedNationalId = Normalizer.trimUpperCase(nationalId);
        String normalized = country.getAlpha2Code() + "00" + normalizedNationalId;
        if (!CreditorIdentifier.isWellFormatted(normalized)) {
            throw CreditorIdentifierFormatException.forNotProperlyFormattedInput(nationalId);
        }
        String checkDigit = IbanCheckDigit.INSTANCE.calculate(normalized);
        this.value = country.getAlpha2Code() + checkDigit + normalizedBusinessCode + normalizedNationalId;
    }

    private static boolean isWellFormatted(String ci) {
        int i;
        int length = ci.length();
        if (length < 8) {
            return false;
        }
        for (i = 0; i < 2; ++i) {
            if (AsciiCharacters.isAlphabetic(ci.charAt(i))) continue;
            return false;
        }
        for (i = 2; i < 4; ++i) {
            if (AsciiCharacters.isNumeric(ci.charAt(i))) continue;
            return false;
        }
        for (i = 4; i < length; ++i) {
            if (AsciiCharacters.isAlphanumeric(ci.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static Optional<IsoCountry> findCountryFor(String ci) {
        return IsoCountry.fromAlpha2Code(ci.substring(0, 2));
    }

    private static String removeBusinessCode(String ci) {
        return ci.substring(0, 4) + ci.substring(7);
    }

    public static boolean isValid(String s) {
        if (s == null) {
            return false;
        }
        String normalized = Normalizer.trimUpperCase(s);
        if (!CreditorIdentifier.isWellFormatted(normalized)) {
            return false;
        }
        Optional<IsoCountry> country = CreditorIdentifier.findCountryFor(normalized);
        if (!country.isPresent()) {
            return false;
        }
        String normalizedCreditorIdWithoutBusinessCode = CreditorIdentifier.removeBusinessCode(normalized);
        return IbanCheckDigit.INSTANCE.validate(normalizedCreditorIdWithoutBusinessCode);
    }

    public String getCountryCode() {
        return this.getCountry().getAlpha2Code();
    }

    public IsoCountry getCountry() {
        return CreditorIdentifier.findCountryFor(this.value).orElseThrow(() -> new IllegalStateException("a valid CI should have a country code"));
    }

    public String getCheckDigit() {
        return this.value.substring(2, 4);
    }

    public String getBusinessCode() {
        return this.value.substring(4, 7);
    }

    public String getNationalIdentifier() {
        return this.value.substring(7);
    }

    public String toString() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreditorIdentifier other = (CreditorIdentifier)o;
        return this.value.equals(other.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

