/*
 * Decompiled with CFR 0.152.
 */
package fr.marcwrobel.jbanking.creditor;

public class CreditorIdentifierFormatException
extends IllegalArgumentException {
    private static final long serialVersionUID = 0L;
    private final String inputString;

    public CreditorIdentifierFormatException(String input, String message) {
        super(message);
        this.inputString = input;
    }

    public static CreditorIdentifierFormatException forNotProperlyFormattedInput(String input) {
        return new CreditorIdentifierFormatException(input, String.format("'%s' format is not appropriate for a CreditorId", input));
    }

    static CreditorIdentifierFormatException forIncorrectCheckDigits(String input) {
        return new CreditorIdentifierFormatException(input, String.format("'%s' check digits are incorrect", input));
    }

    static CreditorIdentifierFormatException forUnknownCountry(String input) {
        return new CreditorIdentifierFormatException(input, String.format("'%s' country code is not an ISO 3166-1-alpha-2 code", input));
    }

    public String getInputString() {
        return this.inputString;
    }
}

