/*
 * Decompiled with CFR 0.152.
 */
package fr.marcwrobel.jbanking.iban;

import fr.marcwrobel.jbanking.iban.BbanStructure;
import fr.marcwrobel.jbanking.iban.Iban;
import fr.marcwrobel.jbanking.iban.IbanPattern;
import fr.marcwrobel.jbanking.iban.IbanPatternGroup;
import java.util.Objects;
import java.util.Random;

public final class RandomIban {
    private final Random random;

    public RandomIban(Random random) {
        this.random = Objects.requireNonNull(random);
    }

    public RandomIban() {
        this(new Random());
    }

    public Iban next() {
        return this.next(BbanStructure.values());
    }

    public Iban next(BbanStructure ... structures) {
        BbanStructure structure = structures[this.random.nextInt(structures.length)];
        IbanPattern pattern = structure.getBbanPattern();
        StringBuilder bban = new StringBuilder(pattern.length);
        for (IbanPatternGroup group : pattern.groups) {
            for (int i = 0; i < group.length; ++i) {
                String alphabet = group.characters.alphabet();
                bban.append(alphabet.charAt(this.random.nextInt(alphabet.length())));
            }
        }
        return new Iban(structure.getCountry(), bban.toString());
    }
}

