/*
 * Decompiled with CFR 0.152.
 */
package fr.marcwrobel.jbanking.swift;

import fr.marcwrobel.jbanking.swift.SwiftPatternCharacterRepresentation;
import fr.marcwrobel.jbanking.swift.SwiftPatternSyntaxException;
import java.io.Serializable;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SwiftPattern
implements Serializable {
    private static final long serialVersionUID = 0L;
    private static final String GROUP_REGEX = "\\d{1,3}!?[ance]";
    private static final Pattern SWIFT_FORMAT_PATTERN = Pattern.compile("^(\\d{1,3}!?[ance]){1,1000}$");
    private static final Pattern SWIFT_FORMAT_GROUPS_PATTERN = Pattern.compile("\\d{1,3}!?[ance]");
    private final String expression;
    private final Pattern equivalentJavaPattern;

    private SwiftPattern(String expression, Pattern equivalentJavaPattern) {
        this.expression = expression;
        this.equivalentJavaPattern = equivalentJavaPattern;
    }

    public static SwiftPattern compile(String expression) {
        if (expression == null) {
            throw new IllegalArgumentException("the given expression cannot be null");
        }
        if (!SWIFT_FORMAT_PATTERN.matcher(expression).matches()) {
            throw new SwiftPatternSyntaxException(expression, "expression must match " + SWIFT_FORMAT_PATTERN);
        }
        return new SwiftPattern(expression, Pattern.compile(SwiftPattern.toRegex(expression)));
    }

    private static String toRegex(String expression) {
        Matcher matcher = SWIFT_FORMAT_GROUPS_PATTERN.matcher(expression);
        StringBuilder regex = new StringBuilder("^");
        while (matcher.find()) {
            regex.append(SwiftPattern.transform(expression, matcher.group()));
        }
        regex.append("$");
        return regex.toString();
    }

    private static String transform(String expression, String groupExpression) {
        int length = groupExpression.length();
        char qualifier = groupExpression.charAt(length - 1);
        Optional<SwiftPatternCharacterRepresentation> cRepresentation = SwiftPatternCharacterRepresentation.from(qualifier);
        if (!cRepresentation.isPresent()) {
            throw new SwiftPatternSyntaxException(expression, "illegal qualifier '" + qualifier + "' in group '" + groupExpression + "'");
        }
        boolean strict = groupExpression.charAt(groupExpression.length() - 2) == '!';
        String maxOccurrences = groupExpression.substring(0, length - (strict ? 2 : 1));
        return cRepresentation.get().regex() + "{" + (strict ? "" : "1,") + maxOccurrences + "}";
    }

    public Matcher matcher(CharSequence input) {
        return this.equivalentJavaPattern.matcher(input);
    }

    public String getExpression() {
        return this.expression;
    }

    public Pattern getEquivalentJavaPattern() {
        return this.equivalentJavaPattern;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SwiftPattern that = (SwiftPattern)o;
        return this.expression.equals(that.expression);
    }

    public int hashCode() {
        return 13 + this.expression.hashCode();
    }

    public String toString() {
        return this.expression;
    }
}

