/*
 * Decompiled with CFR 0.152.
 */
package fr.marcwrobel.jbanking.swift;

import fr.marcwrobel.jbanking.internal.AsciiCharacters;
import fr.marcwrobel.jbanking.internal.CharacterPredicate;
import java.util.Objects;
import java.util.Optional;

public enum SwiftPatternCharacterRepresentation {
    DIGITS('n', "[0-9]", "0123456789", AsciiCharacters::isNumeric),
    UPPER_CASE_LETTERS('a', "[A-Z]", "ABCDEFGHIJKLMNOPQRSTUVWXYZ", AsciiCharacters::isUpperAlphabetic),
    UPPER_AND_LOWER_CASE_ALPHANUMERICS('c', "[a-zA-Z0-9]", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ", AsciiCharacters::isAlphanumeric),
    SPACES('e', "[ ]", " ", AsciiCharacters::isSpace);

    private final char qualifier;
    private final String regex;
    private final String alphabet;
    private final CharacterPredicate predicate;

    public static Optional<SwiftPatternCharacterRepresentation> from(char qualifier) {
        for (SwiftPatternCharacterRepresentation characters : SwiftPatternCharacterRepresentation.values()) {
            if (characters.qualifier != qualifier) continue;
            return Optional.of(characters);
        }
        return Optional.empty();
    }

    private SwiftPatternCharacterRepresentation(char qualifier, String regex, String alphabet, CharacterPredicate predicate) {
        this.qualifier = qualifier;
        this.regex = Objects.requireNonNull(regex);
        this.alphabet = Objects.requireNonNull(alphabet);
        this.predicate = Objects.requireNonNull(predicate);
    }

    public char qualifier() {
        return this.qualifier;
    }

    public String alphabet() {
        return this.alphabet;
    }

    public String regex() {
        return this.regex;
    }

    public boolean has(char c) {
        return this.predicate.test(c);
    }
}

