/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.odt.textstyling;

import fr.opensagres.xdocreport.document.odt.textstyling.IODTStylesGenerator;
import fr.opensagres.xdocreport.document.odt.textstyling.ODTStylesGeneratorProvider;
import fr.opensagres.xdocreport.document.preprocessor.sax.BufferedElement;
import fr.opensagres.xdocreport.document.textstyling.AbstractDocumentHandler;
import fr.opensagres.xdocreport.document.textstyling.IDocumentHandler;
import fr.opensagres.xdocreport.template.IContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class ODTDocumentHandler
extends AbstractDocumentHandler {
    private boolean bolding;
    private boolean italicsing;
    private Stack<Boolean> paragraphsStack;
    private boolean insideHeader = false;
    private int listDepth = 0;
    private List<Boolean> lastItemAlreadyClosed = new ArrayList<Boolean>();
    protected final IODTStylesGenerator styleGen = ODTStylesGeneratorProvider.getStyleGenerator();
    private boolean paragraphWasInserted = false;
    private boolean closeHeader = false;
    protected String itemStyle = "";

    public ODTDocumentHandler(BufferedElement parent, IContext context, String entryName) {
        super(parent, context, entryName);
    }

    public void startDocument() {
        this.bolding = false;
        this.italicsing = false;
        this.paragraphsStack = new Stack();
    }

    public void endDocument() throws IOException {
        this.endParagraphIfNeeded();
    }

    private void endParagraphIfNeeded() throws IOException {
        if (!this.paragraphsStack.isEmpty()) {
            this.paragraphsStack.size();
            for (int i = 0; i < this.paragraphsStack.size(); ++i) {
                this.internalEndParagraph();
            }
            this.paragraphsStack.clear();
        }
    }

    public void startBold() {
        this.bolding = true;
    }

    public void endBold() {
        this.bolding = false;
    }

    public void startItalics() {
        this.italicsing = true;
    }

    public void endItalics() {
        this.italicsing = false;
    }

    public void handleString(String content) throws IOException {
        if (this.insideHeader) {
            super.write(content);
        } else {
            this.startParagraphIfNeeded();
            super.write("<text:span");
            if (this.bolding || this.italicsing) {
                super.write(" text:style-name=\"");
                if (this.bolding && this.italicsing) {
                    super.write(this.styleGen.getBoldItalicStyleName());
                } else if (this.italicsing) {
                    super.write(this.styleGen.getItalicStyleName());
                } else if (this.bolding) {
                    super.write(this.styleGen.getBoldStyleName());
                }
                super.write("\" ");
            }
            super.write(">");
            super.write(content);
            super.write("</text:span>");
        }
    }

    private void startParagraphIfNeeded() throws IOException {
        if (this.paragraphWasInserted && this.paragraphsStack.isEmpty() || this.closeHeader) {
            this.internalStartParagraph(false);
        }
    }

    public void startParagraph() throws IOException {
        super.setTextLocation(IDocumentHandler.TextLocation.End);
        this.internalStartParagraph(false);
    }

    public void endParagraph() throws IOException {
        this.internalEndParagraph();
    }

    private void internalStartParagraph(boolean containerIsList) throws IOException {
        this.internalStartParagraph(containerIsList, null);
    }

    private void internalStartParagraph(boolean containerIsList, String styleName) throws IOException {
        this.closeHeader = false;
        if (styleName == null) {
            super.write("<text:p>");
        } else {
            super.write("<text:p text:style-name=\"");
            super.write(styleName);
            super.write("\">");
        }
        this.paragraphWasInserted = true;
        this.paragraphsStack.push(containerIsList);
    }

    private void internalEndParagraph() throws IOException {
        if (!this.paragraphsStack.isEmpty()) {
            super.write("</text:p>");
            this.paragraphsStack.pop();
        }
    }

    public void startHeading(int level) throws IOException {
        this.endParagraphIfNeeded();
        super.setTextLocation(IDocumentHandler.TextLocation.End);
        super.write("<text:h text:style-name=\"" + this.styleGen.getHeaderStyleName(level) + "\" text:outline-level=\"" + level + "\">");
        this.insideHeader = true;
        this.closeHeader = false;
    }

    public void endHeading(int level) throws IOException {
        super.write("</text:h>");
        this.insideHeader = false;
        this.closeHeader = true;
    }

    protected void doStartOrderedList() throws IOException {
        this.internalStartList(this.styleGen.getOLStyleName());
    }

    protected void doEndOrderedList() throws IOException {
        this.internalEndList();
    }

    protected void doStartUnorderedList() throws IOException {
        this.internalStartList(this.styleGen.getULStyleName());
    }

    protected void doEndUnorderedList() throws IOException {
        this.internalEndList();
    }

    protected void internalStartList(String style) throws IOException {
        this.closeHeader = false;
        super.setTextLocation(IDocumentHandler.TextLocation.End);
        if (this.listDepth == 0) {
            this.endParagraphIfNeeded();
            this.lastItemAlreadyClosed.add(this.listDepth, false);
        } else {
            this.endParagraph();
            this.lastItemAlreadyClosed.add(this.listDepth, true);
        }
        if (style != null) {
            super.write("<text:list text:style-name=\"" + style + "\">");
            this.itemStyle = style;
        } else {
            super.write("<text:list>");
        }
        ++this.listDepth;
    }

    protected void internalEndList() throws IOException {
        super.write("</text:list>");
        --this.listDepth;
        if (this.listDepth == 0) {
            // empty if block
        }
    }

    public void startListItem() throws IOException {
        if (this.itemStyle != null) {
            super.write("<text:list-item text:style-name=\"" + this.itemStyle + "\">");
            this.internalStartParagraph(true, this.itemStyle + this.styleGen.getListItemParagraphStyleNameSuffix());
        } else {
            super.write("<text:list-item>");
            this.internalStartParagraph(true);
        }
    }

    public void endListItem() throws IOException {
        if (this.lastItemAlreadyClosed.size() > this.listDepth && this.lastItemAlreadyClosed.get(this.listDepth).booleanValue()) {
            this.lastItemAlreadyClosed.add(this.listDepth, false);
        }
        this.endParagraphIfNeeded();
        super.write("</text:list-item>");
    }

    public void handleReference(String ref, String label) throws IOException {
        super.write("<text:a xlink:type=\"simple\" xlink:href=\"");
        super.write(ref);
        super.write("\">");
        super.write(label);
        super.write("</text:a>");
    }

    public void handleImage(String ref, String label) throws IOException {
    }
}

