/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.template.formatter;

import fr.opensagres.xdocreport.core.utils.StringUtils;
import fr.opensagres.xdocreport.template.formatter.FieldMetadata;
import fr.opensagres.xdocreport.template.formatter.FieldsMetadataXMLSerializer;
import fr.opensagres.xdocreport.template.formatter.IFieldsMetadataClassSerializer;
import fr.opensagres.xdocreport.template.registry.TemplateEngineRegistry;
import fr.opensagres.xdocreport.template.textstyling.SyntaxKind;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldsMetadata {
    public static final FieldsMetadata EMPTY = new FieldsMetadata();
    public static final String DEFAULT_BEFORE_ROW_TOKEN = "@before-row";
    public static final String DEFAULT_AFTER_ROW_TOKEN = "@after-row";
    public static final String DEFAULT_BEFORE_TABLE_CELL_TOKEN = "@before-cell";
    public static final String DEFAULT_AFTER_TABLE_CELL_TOKEN = "@after-cell";
    private final IFieldsMetadataClassSerializer serializer;
    private final List<FieldMetadata> fields;
    private final Map<String, FieldMetadata> fieldsAsList;
    private final Map<String, FieldMetadata> fieldsAsImage;
    private final Map<String, FieldMetadata> fieldsAsTextStyling;
    private String beforeRowToken;
    private String afterRowToken;
    private String beforeTableCellToken;
    private String afterTableCellToken;

    public FieldsMetadata() {
        this((IFieldsMetadataClassSerializer)null);
    }

    public FieldsMetadata(String templateEngineKind) {
        this(TemplateEngineRegistry.getRegistry().getFieldsMetadataClassSerializer());
    }

    public FieldsMetadata(IFieldsMetadataClassSerializer serializer) {
        this.serializer = serializer;
        this.fields = new ArrayList<FieldMetadata>();
        this.fieldsAsList = new HashMap<String, FieldMetadata>();
        this.fieldsAsImage = new HashMap<String, FieldMetadata>();
        this.fieldsAsTextStyling = new HashMap<String, FieldMetadata>();
        this.beforeRowToken = DEFAULT_BEFORE_ROW_TOKEN;
        this.afterRowToken = DEFAULT_AFTER_ROW_TOKEN;
        this.beforeTableCellToken = DEFAULT_BEFORE_TABLE_CELL_TOKEN;
        this.afterTableCellToken = DEFAULT_AFTER_TABLE_CELL_TOKEN;
    }

    public void addFieldAsImage(String fieldName) {
        this.addFieldAsImage(fieldName, fieldName);
    }

    public void addFieldAsImage(String imageName, String fieldName) {
        this.addField(fieldName, false, imageName, null);
    }

    public void addFieldAsTextStyling(String fieldName, SyntaxKind syntaxKind) {
        this.addFieldAsTextStyling(fieldName, syntaxKind.name());
    }

    public void addFieldAsTextStyling(String fieldName, String syntaxKind) {
        this.addField(fieldName, false, null, syntaxKind);
    }

    public void addFieldAsList(String fieldName) {
        this.addField(fieldName, true, null, null);
    }

    public void addField(String fieldName, boolean listType, String imageName, String syntaxKind) {
        FieldMetadata exsitingField = this.fieldsAsImage.get(fieldName);
        if (exsitingField == null) {
            exsitingField = this.fieldsAsList.get(fieldName);
        }
        if (exsitingField == null) {
            exsitingField = this.fieldsAsTextStyling.get(fieldName);
        }
        if (exsitingField == null) {
            FieldMetadata fieldMetadata = new FieldMetadata(fieldName, listType, imageName, syntaxKind);
            this.fields.add(fieldMetadata);
            if (fieldMetadata.isImageType()) {
                this.fieldsAsImage.put(fieldMetadata.getImageName(), fieldMetadata);
            }
            if (fieldMetadata.isListType()) {
                this.fieldsAsList.put(fieldMetadata.getFieldName(), fieldMetadata);
            }
            if (fieldMetadata.getSyntaxKind() != null) {
                this.fieldsAsTextStyling.put(fieldMetadata.getFieldName(), fieldMetadata);
            }
        } else {
            if (listType && listType != exsitingField.isListType()) {
                exsitingField.setListType(true);
                this.fieldsAsList.put(exsitingField.getFieldName(), exsitingField);
            }
            if (imageName != null && !imageName.equals(exsitingField.getImageName())) {
                exsitingField.setImageName(imageName);
                this.fieldsAsImage.put(imageName, exsitingField);
            }
            if (syntaxKind != null) {
                exsitingField.setSyntaxKind(syntaxKind);
                this.fieldsAsTextStyling.put(imageName, exsitingField);
            }
        }
    }

    public Collection<String> getFieldsAsList() {
        return Collections.unmodifiableCollection(this.fieldsAsList.keySet());
    }

    public Collection<FieldMetadata> getFieldsAsImage() {
        return Collections.unmodifiableCollection(this.fieldsAsImage.values());
    }

    public Collection<FieldMetadata> getFieldsAsTextStyling() {
        return Collections.unmodifiableCollection(this.fieldsAsTextStyling.values());
    }

    public boolean hasFieldsAsImage() {
        return this.fieldsAsImage.size() > 0;
    }

    public boolean isFieldAsImage(String fieldName) {
        if (StringUtils.isEmpty((String)fieldName)) {
            return false;
        }
        return this.fieldsAsImage.containsKey(fieldName);
    }

    public String getImageFieldName(String fieldName) {
        if (StringUtils.isEmpty((String)fieldName)) {
            return null;
        }
        FieldMetadata metadata = this.fieldsAsImage.get(fieldName);
        if (metadata != null) {
            return metadata.getFieldName();
        }
        return null;
    }

    public String getBeforeRowToken() {
        return this.beforeRowToken;
    }

    public void setBeforeRowToken(String beforeRowToken) {
        this.beforeRowToken = beforeRowToken;
    }

    public String getAfterRowToken() {
        return this.afterRowToken;
    }

    public void setAfterRowToken(String afterRowToken) {
        this.afterRowToken = afterRowToken;
    }

    public String getBeforeTableCellToken() {
        return this.beforeTableCellToken;
    }

    public void setBeforeTableCellToken(String beforeTableCellToken) {
        this.beforeTableCellToken = beforeTableCellToken;
    }

    public String getAfterTableCellToken() {
        return this.afterTableCellToken;
    }

    public void setAfterTableCellToken(String afterTableCellToken) {
        this.afterTableCellToken = afterTableCellToken;
    }

    public List<FieldMetadata> getFields() {
        return this.fields;
    }

    public void loadXML(Reader reader) {
        FieldsMetadataXMLSerializer.getInstance().load(this, reader);
    }

    public void saveXML(Writer writer) throws IOException {
        this.saveXML(writer, false);
    }

    public void saveXML(Writer writer, boolean indent) throws IOException {
        FieldsMetadataXMLSerializer.getInstance().save(this, writer, indent);
    }

    public void load(FieldsMetadata fieldsMetadata, String key, Class<?> clazz) {
        if (this.serializer == null) {
            // empty if block
        }
        this.serializer.load(this, key, clazz);
    }

    public void load(FieldsMetadata fieldsMetadata, String key, Class<?> clazz, boolean listType) {
        if (this.serializer == null) {
            // empty if block
        }
        this.serializer.load(this, key, clazz, listType);
    }

    public String toString() {
        StringWriter xml = new StringWriter();
        try {
            this.saveXML(xml, true);
        }
        catch (IOException e) {
            return super.toString();
        }
        return xml.toString();
    }
}

