/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.template.formatter;

import fr.opensagres.xdocreport.template.formatter.FieldMetadata;
import fr.opensagres.xdocreport.template.formatter.FieldsMetadata;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.List;

public class FieldsMetadataXMLSerializer {
    private static final String FIELDS_START_ELT = "<fields>";
    private static final String FIELDS_END_ELT = "</fields>";
    private static final String LF = "\n";
    private static final String TAB = "\t";
    private static final FieldsMetadataXMLSerializer INSTANCE = new FieldsMetadataXMLSerializer();

    public static FieldsMetadataXMLSerializer getInstance() {
        return INSTANCE;
    }

    protected FieldsMetadataXMLSerializer() {
    }

    public void load(FieldsMetadata fieldsMetadata, Reader reader) {
    }

    public void load(FieldsMetadata fieldsMetadata, InputStream inputStream) {
    }

    public void save(FieldsMetadata fieldsMetadata, Writer writer, boolean indent) throws IOException {
        this.save(fieldsMetadata, writer, null, indent);
    }

    public void save(FieldsMetadata fieldsMetadata, OutputStream out, boolean indent) throws IOException {
        this.save(fieldsMetadata, null, out, indent);
    }

    private void save(FieldsMetadata fieldsMetadata, Writer writer, OutputStream out, boolean indent) throws IOException {
        List<FieldMetadata> fields = fieldsMetadata.getFields();
        this.write(FIELDS_START_ELT, writer, out);
        for (FieldMetadata field : fields) {
            this.save(field, writer, out, indent);
        }
        if (indent) {
            this.write(LF, writer, out);
        }
        this.write(FIELDS_END_ELT, writer, out);
    }

    private void save(FieldMetadata field, Writer writer, OutputStream out, boolean indent) throws IOException {
        if (indent) {
            this.write(LF, writer, out);
            this.write(TAB, writer, out);
        }
        this.write("<field", writer, out);
        this.writeAttr("name", field.getFieldName(), writer, out);
        this.write("/>", writer, out);
    }

    private void write(String s, Writer writer, OutputStream out) throws IOException {
        if (writer == null) {
            out.write(s.getBytes());
        } else {
            writer.write(s);
        }
    }

    private void writeAttr(String attrName, String attrValue, Writer writer, OutputStream out) throws IOException {
        this.write(" ", writer, out);
        this.write(attrName, writer, out);
        this.write("=\"", writer, out);
        this.write(attrValue, writer, out);
        this.write("\"", writer, out);
    }
}

