/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.template.textstyling;

import fr.opensagres.xdocreport.template.textstyling.IDocumentHandler;
import java.io.StringWriter;
import java.util.Stack;

public abstract class AbstractDocumentHandler
implements IDocumentHandler {
    protected final StringWriter writer = new StringWriter();
    private final Stack<Boolean> listStack = new Stack();

    public void handleString(String s) {
        this.writer.write(s);
    }

    public String toString() {
        return this.writer.toString();
    }

    public final void startOrderedList() {
        this.listStack.push(true);
        this.doStartOrderedList();
    }

    public final void endOrderedList() {
        this.listStack.pop();
        this.doEndOrderedList();
    }

    public final void startUnorderedList() {
        this.listStack.push(false);
        this.doStartUnorderedList();
    }

    public final void endUnorderedList() {
        this.listStack.pop();
        this.doEndUnorderedList();
    }

    protected boolean getCurrentListOrder() {
        if (this.listStack.isEmpty()) {
            return false;
        }
        return this.listStack.peek();
    }

    protected int getCurrentListIndex() {
        if (this.listStack.isEmpty()) {
            return 0;
        }
        return this.listStack.size() - 1;
    }

    protected void doEndUnorderedList() {
    }

    protected void doEndOrderedList() {
    }

    protected void doStartUnorderedList() {
    }

    protected void doStartOrderedList() {
    }
}

