/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.template.textstyling;

import fr.opensagres.xdocreport.core.XDocReportException;
import fr.opensagres.xdocreport.core.logging.LogUtils;
import fr.opensagres.xdocreport.template.textstyling.IDocumentHandler;
import fr.opensagres.xdocreport.template.textstyling.ITextStylingTransformer;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractTextStylingTransformer
implements ITextStylingTransformer {
    private static final Logger LOGGER = LogUtils.getLogger((String)AbstractTextStylingTransformer.class.getName());

    public String transform(String content, IDocumentHandler handler) throws XDocReportException {
        try {
            this.doTransform(content, handler);
            String result = handler.toString();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(result);
            }
            return result;
        }
        catch (Throwable e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.severe(e.getMessage());
            }
            if (e instanceof XDocReportException) {
                throw (XDocReportException)e;
            }
            throw new XDocReportException(e);
        }
    }

    protected abstract void doTransform(String var1, IDocumentHandler var2) throws Exception;
}

