/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.template.textstyling.html;

import fr.opensagres.xdocreport.template.textstyling.IDocumentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class HTMLTextStylingContentHandler
extends DefaultHandler {
    private static final String STRONG_ELT = "strong";
    private static final String B_ELT = "b";
    private static final String EM_ELT = "em";
    private static final String I_ELT = "i";
    private static final String OL_ELT = "ol";
    private static final String UL_ELT = "ul";
    private static final String LI_ELT = "li";
    private static final String P_ELT = "p";
    private final IDocumentHandler documentHandler;

    public HTMLTextStylingContentHandler(IDocumentHandler visitor) {
        this.documentHandler = visitor;
    }

    public void startDocument() throws SAXException {
        super.startDocument();
        this.documentHandler.startDocument();
    }

    public void endDocument() throws SAXException {
        super.endDocument();
        this.documentHandler.endDocument();
    }

    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (STRONG_ELT.equals(name) || B_ELT.equals(name)) {
            this.documentHandler.startBold();
        } else if (EM_ELT.equals(name) || I_ELT.equals(name)) {
            this.documentHandler.startItalics();
        } else if (UL_ELT.equals(name)) {
            this.startList(false);
        } else if (OL_ELT.equals(name)) {
            this.startList(true);
        } else if (LI_ELT.equals(name)) {
            this.documentHandler.startListItem();
        } else if (P_ELT.equals(name)) {
            this.documentHandler.startParagraph();
        }
        super.startElement(uri, localName, name, attributes);
    }

    public void endElement(String uri, String localName, String name) throws SAXException {
        if (STRONG_ELT.equals(name) || B_ELT.equals(name)) {
            this.documentHandler.endBold();
        } else if (EM_ELT.equals(name) || I_ELT.equals(name)) {
            this.documentHandler.endItalics();
        } else if (UL_ELT.equals(name)) {
            this.endList(false);
        } else if (OL_ELT.equals(name)) {
            this.endList(true);
        } else if (LI_ELT.equals(name)) {
            this.documentHandler.endListItem();
        } else if (P_ELT.equals(name)) {
            this.documentHandler.endParagraph();
        }
        super.endElement(uri, localName, name);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.documentHandler.handleString(String.valueOf(ch, start, length));
        super.characters(ch, start, length);
    }

    private void startList(boolean ordered) {
        if (ordered) {
            this.documentHandler.startOrderedList();
        } else {
            this.documentHandler.startUnorderedList();
        }
    }

    private void endList(boolean ordered) {
        if (ordered) {
            this.documentHandler.endOrderedList();
        } else {
            this.documentHandler.endUnorderedList();
        }
    }
}

