/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.template.textstyling.html;

import fr.opensagres.xdocreport.core.logging.LogUtils;
import fr.opensagres.xdocreport.core.utils.StringUtils;
import fr.opensagres.xdocreport.template.textstyling.AbstractTextStylingTransformer;
import fr.opensagres.xdocreport.template.textstyling.IDocumentHandler;
import fr.opensagres.xdocreport.template.textstyling.ITextStylingTransformer;
import fr.opensagres.xdocreport.template.textstyling.html.HTMLTextStylingContentHandler;
import java.io.StringReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class HTMLTextStylingTransformer
extends AbstractTextStylingTransformer {
    public static final ITextStylingTransformer INSTANCE = new HTMLTextStylingTransformer();
    private static final Logger LOGGER = LogUtils.getLogger((String)HTMLTextStylingTransformer.class.getName());
    private static final String[] searchList = new String[]{"\r", "\n", "\t"};
    private static final String[] replacementList = new String[]{"", "", ""};

    protected void doTransform(String content, IDocumentHandler documentHandler) throws Exception {
        String xml = StringUtils.replaceEach((String)content, (String[])searchList, (String[])replacementList);
        xml = "<root>" + xml + "</root>";
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(xml);
        }
        XMLReader xmlReader = XMLReaderFactory.createXMLReader();
        xmlReader.setContentHandler(new HTMLTextStylingContentHandler(documentHandler));
        xmlReader.parse(new InputSource(new StringReader(xml)));
    }
}

