/*
 * Decompiled with CFR 0.152.
 */
package fr.openwide.nuxeo.avatar;

import fr.openwide.nuxeo.avatar.AvatarImporterConfigDescriptor;
import fr.openwide.nuxeo.avatar.AvatarImporterService;
import java.io.File;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.log4j.Logger;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.core.blob.binary.DefaultBinaryManager;
import org.nuxeo.ecm.user.center.profile.UserProfileService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class AvatarImporterServiceImpl
extends DefaultComponent
implements AvatarImporterService {
    public static Logger logger = Logger.getLogger(AvatarImporterServiceImpl.class);
    public static final String EXTENSION_POINT_CONFIG = "config";
    private static String avatarFolderPath = null;
    private static MessageDigest messageDigest = null;

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (EXTENSION_POINT_CONFIG.equals(extensionPoint)) {
            this.registerConfiguration((AvatarImporterConfigDescriptor)contribution);
        }
    }

    @Override
    public void registerConfiguration(AvatarImporterConfigDescriptor config) {
        avatarFolderPath = config.dossierAvatars;
    }

    @Override
    public String getAvatarFolderPath() {
        return avatarFolderPath;
    }

    @Override
    public void importAvatars(CoreSession coreSession) throws NuxeoException {
        if (avatarFolderPath != null) {
            File avatarFolder = new File(avatarFolderPath);
            if (avatarFolder.exists() && avatarFolder.isDirectory()) {
                int replacedAvatars = 0;
                try {
                    File[] avatarFiles;
                    UserProfileService userProfileService = (UserProfileService)Framework.getService(UserProfileService.class);
                    for (File avatarFile : avatarFiles = avatarFolder.listFiles()) {
                        String filename = avatarFile.getName();
                        String username = filename.substring(0, filename.lastIndexOf("."));
                        DocumentModel userProfile = userProfileService.getUserProfileDocument(username, coreSession);
                        if (userProfile == null) continue;
                        boolean replaceBlob = true;
                        Blob previousBlob = (Blob)userProfile.getPropertyValue("userprofile:avatar");
                        FileBlob newBlob = new FileBlob(avatarFile);
                        if (previousBlob != null && previousBlob.getDigest().equals(DefaultBinaryManager.toHexString((byte[])messageDigest.digest(newBlob.getByteArray())))) {
                            replaceBlob = false;
                        }
                        if (!replaceBlob) continue;
                        userProfile.setPropertyValue("userprofile:avatar", (Serializable)newBlob);
                        coreSession.saveDocument(userProfile);
                        ++replacedAvatars;
                    }
                }
                catch (Exception e) {
                    throw new NuxeoException((Throwable)e);
                }
                if (replacedAvatars > 0) {
                    logger.info((Object)(replacedAvatars + " avatars imported from " + avatarFolderPath));
                }
            } else {
                logger.warn((Object)("Cannot import avatars, folder not found : " + avatarFolderPath));
            }
        }
    }

    static {
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            logger.error((Object)"MD5 digest missing from this Java platform", (Throwable)e);
        }
    }
}

