/*
 * Decompiled with CFR 0.152.
 */
package fr.pilato.elasticsearch.tools;

import fr.pilato.elasticsearch.tools.SettingsFinder;
import fr.pilato.elasticsearch.tools.index.IndexElasticsearchUpdater;
import fr.pilato.elasticsearch.tools.index.IndexFinder;
import fr.pilato.elasticsearch.tools.template.TemplateElasticsearchUpdater;
import fr.pilato.elasticsearch.tools.template.TemplateFinder;
import fr.pilato.elasticsearch.tools.type.TypeElasticsearchUpdater;
import fr.pilato.elasticsearch.tools.type.TypeFinder;
import java.util.List;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.RestClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchBeyonder {
    private static final Logger logger = LoggerFactory.getLogger(ElasticsearchBeyonder.class);

    public static void start(RestClient client) throws Exception {
        ElasticsearchBeyonder.start(client, SettingsFinder.Defaults.ConfigDir);
    }

    public static void start(RestClient client, String root) throws Exception {
        ElasticsearchBeyonder.start(client, root, SettingsFinder.Defaults.MergeMappings, SettingsFinder.Defaults.ForceCreation);
    }

    public static void start(RestClient client, String root, boolean merge, boolean force) throws Exception {
        logger.info("starting automatic settings/mappings discovery");
        List<String> templateNames = TemplateFinder.findTemplates(root);
        for (String templateName : templateNames) {
            TemplateElasticsearchUpdater.createTemplate(client, root, templateName, force);
        }
        List<String> indexNames = IndexFinder.findIndexNames(root);
        for (String indexName : indexNames) {
            IndexElasticsearchUpdater.createIndex(client, root, indexName, force);
            IndexElasticsearchUpdater.updateSettings(client, root, indexName);
            List<String> types = TypeFinder.findTypes(root, indexName);
            for (String typeName : types) {
                TypeElasticsearchUpdater.createMapping(client, root, indexName, typeName, merge);
            }
        }
        logger.info("start done. Rock & roll!");
    }

    @Deprecated
    public static void start(Client client) throws Exception {
        ElasticsearchBeyonder.start(client, SettingsFinder.Defaults.ConfigDir);
    }

    @Deprecated
    public static void start(Client client, String root) throws Exception {
        logger.info("starting automatic settings/mappings discovery");
        boolean merge = SettingsFinder.Defaults.MergeMappings;
        boolean force = SettingsFinder.Defaults.ForceCreation;
        List<String> templateNames = TemplateFinder.findTemplates(root);
        for (String templateName : templateNames) {
            TemplateElasticsearchUpdater.createTemplate(client, root, templateName, force);
        }
        List<String> indexNames = IndexFinder.findIndexNames(root);
        for (String indexName : indexNames) {
            IndexElasticsearchUpdater.createIndex(client, root, indexName, force);
            IndexElasticsearchUpdater.updateSettings(client, root, indexName);
            List<String> types = TypeFinder.findTypes(root, indexName);
            for (String typeName : types) {
                TypeElasticsearchUpdater.createMapping(client, root, indexName, typeName, merge);
            }
        }
        logger.info("start done. Rock & roll!");
    }
}

