/*
 * Decompiled with CFR 0.152.
 */
package fr.pilato.elasticsearch.tools.index;

import fr.pilato.elasticsearch.tools.index.IndexSettingsReader;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.common.xcontent.XContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexElasticsearchUpdater {
    private static final Logger logger = LoggerFactory.getLogger(IndexElasticsearchUpdater.class);

    @Deprecated
    public static void createIndex(Client client, String root, String index, boolean force) throws Exception {
        String settings = IndexSettingsReader.readSettings(root, index);
        IndexElasticsearchUpdater.createIndexWithSettings(client, index, settings, force);
    }

    @Deprecated
    public static void createIndex(Client client, String index, boolean force) throws Exception {
        String settings = IndexSettingsReader.readSettings(index);
        IndexElasticsearchUpdater.createIndexWithSettings(client, index, settings, force);
    }

    @Deprecated
    public static void createIndexWithSettings(Client client, String index, String settings, boolean force) throws Exception {
        if (force && IndexElasticsearchUpdater.isIndexExist(client, index)) {
            logger.debug("Index [{}] already exists but force set to true. Removing all data!", (Object)index);
            IndexElasticsearchUpdater.removeIndexInElasticsearch(client, index);
        }
        if (force || !IndexElasticsearchUpdater.isIndexExist(client, index)) {
            logger.debug("Index [{}] doesn't exist. Creating it.", (Object)index);
            IndexElasticsearchUpdater.createIndexWithSettingsInElasticsearch(client, index, settings);
        } else {
            logger.debug("Index [{}] already exists.", (Object)index);
        }
    }

    @Deprecated
    private static void removeIndexInElasticsearch(Client client, String index) throws Exception {
        logger.trace("removeIndex([{}])", (Object)index);
        assert (client != null);
        assert (index != null);
        AcknowledgedResponse response = (AcknowledgedResponse)client.admin().indices().prepareDelete(new String[]{index}).get();
        if (!response.isAcknowledged()) {
            logger.warn("Could not delete index [{}]", (Object)index);
            throw new Exception("Could not delete index [" + index + "].");
        }
        logger.trace("/removeIndex([{}])", (Object)index);
    }

    @Deprecated
    private static void createIndexWithSettingsInElasticsearch(Client client, String index, String settings) throws Exception {
        CreateIndexResponse createIndexResponse;
        logger.trace("createIndex([{}])", (Object)index);
        assert (client != null);
        assert (index != null);
        CreateIndexRequestBuilder cirb = client.admin().indices().prepareCreate(index);
        if (settings != null) {
            logger.trace("Found settings for index [{}]: [{}]", (Object)index, (Object)settings);
            cirb.setSource(settings, XContentType.JSON);
        }
        if (!(createIndexResponse = (CreateIndexResponse)cirb.execute().actionGet()).isAcknowledged()) {
            logger.warn("Could not create index [{}]", (Object)index);
            throw new Exception("Could not create index [" + index + "].");
        }
        logger.trace("/createIndex([{}])", (Object)index);
    }

    @Deprecated
    private static void updateIndexWithSettingsInElasticsearch(Client client, String index, String settings) throws Exception {
        logger.trace("updateIndex([{}])", (Object)index);
        assert (client != null);
        assert (index != null);
        if (settings != null) {
            logger.trace("Found update settings for index [{}]: [{}]", (Object)index, (Object)settings);
            logger.debug("updating settings for index [{}]", (Object)index);
            client.admin().indices().prepareUpdateSettings(new String[]{index}).setSettings(settings, XContentType.JSON).get();
        }
        logger.trace("/updateIndex([{}])", (Object)index);
    }

    @Deprecated
    public static boolean isIndexExist(Client client, String index) {
        return ((IndicesExistsResponse)client.admin().indices().prepareExists(new String[]{index}).get()).isExists();
    }

    @Deprecated
    public static void updateSettings(Client client, String root, String index) throws Exception {
        String settings = IndexSettingsReader.readUpdateSettings(root, index);
        IndexElasticsearchUpdater.updateIndexWithSettingsInElasticsearch(client, index, settings);
    }

    @Deprecated
    public static void updateSettings(Client client, String index) throws Exception {
        String settings = IndexSettingsReader.readUpdateSettings(index);
        IndexElasticsearchUpdater.updateIndexWithSettingsInElasticsearch(client, index, settings);
    }

    public static void createIndex(RestClient client, String root, String index, boolean force) throws Exception {
        String settings = IndexSettingsReader.readSettings(root, index);
        IndexElasticsearchUpdater.createIndexWithSettings(client, index, settings, force);
    }

    public static void createIndex(RestClient client, String index, boolean force) throws Exception {
        String settings = IndexSettingsReader.readSettings(index);
        IndexElasticsearchUpdater.createIndexWithSettings(client, index, settings, force);
    }

    public static void createIndexWithSettings(RestClient client, String index, String settings, boolean force) throws Exception {
        if (force && IndexElasticsearchUpdater.isIndexExist(client, index)) {
            logger.debug("Index [{}] already exists but force set to true. Removing all data!", (Object)index);
            IndexElasticsearchUpdater.removeIndexInElasticsearch(client, index);
        }
        if (force || !IndexElasticsearchUpdater.isIndexExist(client, index)) {
            logger.debug("Index [{}] doesn't exist. Creating it.", (Object)index);
            IndexElasticsearchUpdater.createIndexWithSettingsInElasticsearch(client, index, settings);
        } else {
            logger.debug("Index [{}] already exists.", (Object)index);
        }
    }

    private static void removeIndexInElasticsearch(RestClient client, String index) throws Exception {
        logger.trace("removeIndex([{}])", (Object)index);
        assert (client != null);
        assert (index != null);
        Response response = client.performRequest(new Request("DELETE", "/" + index));
        if (response.getStatusLine().getStatusCode() != 200) {
            logger.warn("Could not delete index [{}]", (Object)index);
            throw new Exception("Could not delete index [" + index + "].");
        }
        logger.trace("/removeIndex([{}])", (Object)index);
    }

    private static void createIndexWithSettingsInElasticsearch(RestClient client, String index, String settings) throws Exception {
        Response response;
        logger.trace("createIndex([{}])", (Object)index);
        assert (client != null);
        assert (index != null);
        Request request = new Request("PUT", "/" + index);
        if (settings != null) {
            logger.trace("Found settings for index [{}]: [{}]", (Object)index, (Object)settings);
            request.setJsonEntity(settings);
        }
        if ((response = client.performRequest(request)).getStatusLine().getStatusCode() != 200) {
            logger.warn("Could not create index [{}]", (Object)index);
            throw new Exception("Could not create index [" + index + "].");
        }
        logger.trace("/createIndex([{}])", (Object)index);
    }

    private static void updateIndexWithSettingsInElasticsearch(RestClient client, String index, String settings) throws Exception {
        logger.trace("updateIndex([{}])", (Object)index);
        assert (client != null);
        assert (index != null);
        if (settings != null) {
            logger.trace("Found update settings for index [{}]: [{}]", (Object)index, (Object)settings);
            logger.debug("updating settings for index [{}]", (Object)index);
            Request request = new Request("PUT", "/" + index + "/_settings");
            request.setJsonEntity(settings);
            client.performRequest(request);
        }
        logger.trace("/updateIndex([{}])", (Object)index);
    }

    public static boolean isIndexExist(RestClient client, String index) throws Exception {
        Response response = client.performRequest(new Request("HEAD", "/" + index));
        return response.getStatusLine().getStatusCode() == 200;
    }

    public static void updateSettings(RestClient client, String root, String index) throws Exception {
        String settings = IndexSettingsReader.readUpdateSettings(root, index);
        IndexElasticsearchUpdater.updateIndexWithSettingsInElasticsearch(client, index, settings);
    }

    public static void updateSettings(RestClient client, String index) throws Exception {
        String settings = IndexSettingsReader.readUpdateSettings(index);
        IndexElasticsearchUpdater.updateIndexWithSettingsInElasticsearch(client, index, settings);
    }
}

