/*
 * Decompiled with CFR 0.152.
 */
package fr.pilato.elasticsearch.tools.index;

import fr.pilato.elasticsearch.tools.ResourceList;
import fr.pilato.elasticsearch.tools.SettingsFinder;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexFinder
extends SettingsFinder {
    private static final Logger logger = LoggerFactory.getLogger(IndexFinder.class);

    public static List<String> findIndexNames() throws IOException, URISyntaxException {
        return IndexFinder.findIndexNames(SettingsFinder.Defaults.ConfigDir);
    }

    public static List<String> findIndexNames(String root) throws IOException, URISyntaxException {
        String[] resources;
        if (root == null) {
            return IndexFinder.findIndexNames();
        }
        logger.debug("Looking for indices in classpath under [{}].", (Object)root);
        ArrayList<String> indexNames = new ArrayList<String>();
        HashSet<String> keys = new HashSet<String>();
        for (String resource : resources = ResourceList.getResources(root + "/")) {
            if (resource.isEmpty()) continue;
            logger.trace(" - resource [{}].", (Object)resource);
            String key = resource.contains("/") ? resource.substring(0, resource.indexOf("/")) : resource;
            if (key.equals(SettingsFinder.Defaults.TemplateDir) || keys.contains(key)) continue;
            logger.trace(" - found [{}].", (Object)key);
            keys.add(key);
            indexNames.add(key);
        }
        return indexNames;
    }
}

