/*
 * Decompiled with CFR 0.152.
 */
package fr.pilato.elasticsearch.tools.template;

import fr.pilato.elasticsearch.tools.template.TemplateSettingsReader;
import java.io.IOException;
import org.elasticsearch.action.admin.indices.template.get.GetIndexTemplatesResponse;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.common.xcontent.XContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateElasticsearchUpdater {
    private static final Logger logger = LoggerFactory.getLogger(TemplateElasticsearchUpdater.class);

    @Deprecated
    public static void createTemplate(Client client, String root, String template, boolean force) throws Exception {
        String json = TemplateSettingsReader.readTemplate(root, template);
        TemplateElasticsearchUpdater.createTemplateWithJson(client, template, json, force);
    }

    @Deprecated
    public static void createTemplate(Client client, String template, boolean force) throws Exception {
        String json = TemplateSettingsReader.readTemplate(template);
        TemplateElasticsearchUpdater.createTemplateWithJson(client, template, json, force);
    }

    @Deprecated
    public static void createTemplateWithJson(Client client, String template, String json, boolean force) throws Exception {
        if (TemplateElasticsearchUpdater.isTemplateExist(client, template)) {
            if (force) {
                logger.debug("Template [{}] already exists. Force is set. Removing it.", (Object)template);
                TemplateElasticsearchUpdater.removeTemplate(client, template);
            } else {
                logger.debug("Template [{}] already exists.", (Object)template);
            }
        }
        if (!TemplateElasticsearchUpdater.isTemplateExist(client, template)) {
            logger.debug("Template [{}] doesn't exist. Creating it.", (Object)template);
            TemplateElasticsearchUpdater.createTemplateWithJsonInElasticsearch(client, template, json);
        }
    }

    @Deprecated
    private static void createTemplateWithJsonInElasticsearch(Client client, String template, String json) throws Exception {
        logger.trace("createTemplate([{}])", (Object)template);
        assert (client != null);
        assert (template != null);
        AcknowledgedResponse response = (AcknowledgedResponse)client.admin().indices().preparePutTemplate(template).setSource(json.getBytes(), XContentType.JSON).get();
        if (!response.isAcknowledged()) {
            logger.warn("Could not create template [{}]", (Object)template);
            throw new Exception("Could not create template [" + template + "].");
        }
        logger.trace("/createTemplate([{}])", (Object)template);
    }

    @Deprecated
    public static boolean isTemplateExist(Client client, String template) {
        return !((GetIndexTemplatesResponse)client.admin().indices().prepareGetTemplates(new String[]{template}).get()).getIndexTemplates().isEmpty();
    }

    @Deprecated
    public static void removeTemplate(Client client, String template) {
        logger.trace("removeTemplate({})", (Object)template);
        client.admin().indices().prepareDeleteTemplate(template).get();
        logger.trace("/removeTemplate({})", (Object)template);
    }

    public static void createTemplate(RestClient client, String root, String template, boolean force) throws Exception {
        String json = TemplateSettingsReader.readTemplate(root, template);
        TemplateElasticsearchUpdater.createTemplateWithJson(client, template, json, force);
    }

    public static void createTemplate(RestClient client, String template, boolean force) throws Exception {
        String json = TemplateSettingsReader.readTemplate(template);
        TemplateElasticsearchUpdater.createTemplateWithJson(client, template, json, force);
    }

    public static void createTemplateWithJson(RestClient client, String template, String json, boolean force) throws Exception {
        if (TemplateElasticsearchUpdater.isTemplateExist(client, template)) {
            if (force) {
                logger.debug("Template [{}] already exists. Force is set. Removing it.", (Object)template);
                TemplateElasticsearchUpdater.removeTemplate(client, template);
            } else {
                logger.debug("Template [{}] already exists.", (Object)template);
            }
        }
        if (!TemplateElasticsearchUpdater.isTemplateExist(client, template)) {
            logger.debug("Template [{}] doesn't exist. Creating it.", (Object)template);
            TemplateElasticsearchUpdater.createTemplateWithJsonInElasticsearch(client, template, json);
        }
    }

    private static void createTemplateWithJsonInElasticsearch(RestClient client, String template, String json) throws Exception {
        logger.trace("createTemplate([{}])", (Object)template);
        assert (client != null);
        assert (template != null);
        Request request = new Request("PUT", "/_template/" + template);
        request.setJsonEntity(json);
        Response response = client.performRequest(request);
        if (response.getStatusLine().getStatusCode() != 200) {
            logger.warn("Could not create template [{}]", (Object)template);
            throw new Exception("Could not create template [" + template + "].");
        }
        logger.trace("/createTemplate([{}])", (Object)template);
    }

    public static boolean isTemplateExist(RestClient client, String template) throws IOException {
        Response response = client.performRequest(new Request("HEAD", "/_template/" + template));
        return response.getStatusLine().getStatusCode() == 200;
    }

    public static void removeTemplate(RestClient client, String template) throws Exception {
        logger.trace("removeTemplate({})", (Object)template);
        client.performRequest(new Request("DELETE", "/_template/" + template));
        logger.trace("/removeTemplate({})", (Object)template);
    }
}

