/*
 * Decompiled with CFR 0.152.
 */
package fr.pilato.elasticsearch.tools.template;

import fr.pilato.elasticsearch.tools.ResourceList;
import fr.pilato.elasticsearch.tools.SettingsFinder;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateFinder
extends SettingsFinder {
    private static final Logger logger = LoggerFactory.getLogger(TemplateFinder.class);

    public static List<String> findTemplates() throws IOException, URISyntaxException {
        return TemplateFinder.findTemplates(SettingsFinder.Defaults.ConfigDir);
    }

    public static List<String> findTemplates(String root) throws IOException, URISyntaxException {
        String[] resources;
        if (root == null) {
            return TemplateFinder.findTemplates();
        }
        logger.debug("Looking for templates in classpath under [{}].", (Object)root);
        ArrayList<String> templateNames = new ArrayList<String>();
        for (String resource : resources = ResourceList.getResources(root + "/" + SettingsFinder.Defaults.TemplateDir + "/")) {
            if (resource.isEmpty()) continue;
            String withoutIndex = resource.substring(resource.indexOf("/") + 1);
            String template = withoutIndex.substring(0, withoutIndex.indexOf(SettingsFinder.Defaults.JsonFileExtension));
            logger.trace(" - found [{}].", (Object)template);
            templateNames.add(template);
        }
        return templateNames;
    }
}

