/*
 * Decompiled with CFR 0.152.
 */
package fr.pilato.elasticsearch.tools.updaters;

import fr.pilato.elasticsearch.tools.util.DefaultSettings;
import fr.pilato.elasticsearch.tools.util.SettingsReader;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchComponentTemplateUpdater {
    private static final Logger logger = LoggerFactory.getLogger(ElasticsearchComponentTemplateUpdater.class);

    private ElasticsearchComponentTemplateUpdater() {
    }

    public static void createComponentTemplate(RestClient client, String root, String template) throws Exception {
        String json = SettingsReader.getJsonContent(root, DefaultSettings.ComponentTemplatesDir, template + DefaultSettings.JsonFileExtension);
        ElasticsearchComponentTemplateUpdater.createComponentTemplateWithJsonInElasticsearch(client, template, json);
    }

    private static void createComponentTemplateWithJsonInElasticsearch(RestClient client, String template, String json) throws Exception {
        logger.trace("createComponentTemplate([{}])", (Object)template);
        assert (client != null);
        assert (template != null);
        Request request = new Request("PUT", "/_component_template/" + template);
        request.setJsonEntity(json);
        Response response = client.performRequest(request);
        if (response.getStatusLine().getStatusCode() != 200) {
            logger.warn("Could not create component template [{}]", (Object)template);
            throw new Exception("Could not create component template [" + template + "].");
        }
        logger.trace("/createComponentTemplate([{}])", (Object)template);
    }
}

