/*
 * Decompiled with CFR 0.152.
 */
package fr.pilato.elasticsearch.tools.util;

import fr.pilato.elasticsearch.tools.util.DefaultSettings;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceList {
    private static final Logger logger = LoggerFactory.getLogger(ResourceList.class);
    private static final String[] NO_RESOURCE = new String[0];

    private ResourceList() {
    }

    public static String[] getResources(String root) throws URISyntaxException, IOException {
        logger.trace("Reading classpath resources from {}", (Object)root);
        URL dirURL = ResourceList.class.getClassLoader().getResource(root);
        if (dirURL != null && dirURL.getProtocol().equals("file")) {
            logger.trace("found a file resource: {}", (Object)dirURL);
            Object[] resources = new File(dirURL.toURI()).list();
            if (resources == null) {
                return NO_RESOURCE;
            }
            Arrays.sort(resources);
            return resources;
        }
        if (dirURL == null) {
            String me = ResourceList.class.getName().replace(".", "/") + ".class";
            dirURL = ResourceList.class.getClassLoader().getResource(me);
        }
        if (dirURL == null) {
            throw new RuntimeException("can not get resource file " + root);
        }
        if (dirURL.getProtocol().equals("jar")) {
            logger.trace("found a jar file resource: {}", (Object)dirURL);
            String jarPath = dirURL.getPath().substring(5, dirURL.getPath().indexOf("!"));
            String prefix = dirURL.getPath().substring(5 + jarPath.length()).replaceAll("!", "").substring(1);
            HashSet<String> result = new HashSet<String>();
            try (JarFile jar = new JarFile(URLDecoder.decode(jarPath, "UTF-8"));){
                Enumeration<JarEntry> entries = jar.entries();
                while (entries.hasMoreElements()) {
                    String name = entries.nextElement().getName();
                    if (!name.startsWith(prefix)) continue;
                    String entry = name.substring(prefix.length());
                    int checkSubdir = entry.indexOf("/");
                    if (checkSubdir >= 0) {
                        entry = entry.substring(0, checkSubdir);
                    }
                    result.add(entry);
                }
            }
            Object[] resources = result.toArray(new String[0]);
            Arrays.sort(resources);
            return resources;
        }
        logger.trace("did not find any resource. returning empty array");
        return NO_RESOURCE;
    }

    public static List<String> extractNamesFromJsonResources(String[] resources) {
        ArrayList<String> names = new ArrayList<String>();
        for (String resource : resources) {
            if (resource.isEmpty()) continue;
            String withoutIndex = resource.substring(resource.indexOf("/") + 1);
            String name = withoutIndex.substring(0, withoutIndex.indexOf(DefaultSettings.JsonFileExtension));
            logger.trace(" - found [{}].", (Object)name);
            names.add(name);
        }
        return names;
    }

    public static List<String> getResourceNames(String root, String subdir) throws URISyntaxException, IOException {
        String path = root;
        if (root == null) {
            path = DefaultSettings.ConfigDir;
        }
        path = path + "/" + subdir + "/";
        logger.debug("Looking for resources in classpath under [{}].", (Object)path);
        return ResourceList.extractNamesFromJsonResources(ResourceList.getResources(path));
    }

    public static List<String> findIndexNames(String root) throws IOException, URISyntaxException {
        String[] resources;
        String path = root;
        if (root == null) {
            path = DefaultSettings.ConfigDir;
        }
        logger.debug("Looking for indices in classpath under [{}].", (Object)path);
        ArrayList<String> indexNames = new ArrayList<String>();
        HashSet<String> keys = new HashSet<String>();
        for (String resource : resources = ResourceList.getResources(path + "/")) {
            if (resource.isEmpty()) continue;
            logger.trace(" - resource [{}].", (Object)resource);
            String key = resource.contains("/") ? resource.substring(0, resource.indexOf("/")) : resource;
            if (key.equals(DefaultSettings.IndexTemplatesDir) || key.equals(DefaultSettings.ComponentTemplatesDir) || key.equals(DefaultSettings.PipelinesDir) || key.equals(DefaultSettings.AliasesFile) || key.equals(DefaultSettings.IndexLifecyclesDir) || key.equals(DefaultSettings.DataDir) || keys.contains(key)) continue;
            logger.trace(" - found [{}].", (Object)key);
            keys.add(key);
            indexNames.add(key);
        }
        return indexNames;
    }

    public static Collection<String> findBulkFiles(String root, String index) throws IOException, URISyntaxException {
        return ResourceList.findFilesByExtension(root, index, DefaultSettings.NdJsonFileExtension);
    }

    public static Collection<String> findJsonFiles(String root, String index) throws IOException, URISyntaxException {
        return ResourceList.findFilesByExtension(root, index, DefaultSettings.JsonFileExtension);
    }

    private static Collection<String> findFilesByExtension(String root, String index, String extension) throws IOException, URISyntaxException {
        String[] resources;
        String path = root;
        String indexName = index;
        if (path == null) {
            path = DefaultSettings.ConfigDir;
        }
        indexName = indexName == null ? DefaultSettings.DataDir : indexName + "/" + DefaultSettings.DataDir;
        logger.debug("Looking for [{}] files in classpath under [{}/{}].", new Object[]{extension, path, indexName});
        HashSet<String> filenames = new HashSet<String>();
        for (String resource : resources = ResourceList.getResources(path + "/" + indexName)) {
            if (resource.isEmpty()) continue;
            logger.trace(" - resource [{}].", (Object)resource);
            String key = resource.contains("/") ? resource.substring(0, resource.indexOf("/")) : resource;
            if (!key.endsWith(extension) || filenames.contains(key)) continue;
            logger.trace(" - found [{}].", (Object)key);
            filenames.add(key);
        }
        ArrayList<String> sortedFilenames = new ArrayList<String>(filenames);
        Collections.sort(sortedFilenames);
        return sortedFilenames;
    }

    public static String replaceIndexName(String indexName) {
        logger.trace("replaceIndexName({})", (Object)indexName);
        try {
            String replaced = URLDecoder.decode(indexName, "UTF8").replaceAll("\\{[^}]*\\}", "*").replaceAll("<([^>]*)>", "$1").replaceAll("-\\d{6}", "-*");
            logger.trace("/replaceIndexName({}) = [{}]", (Object)indexName, (Object)replaced);
            return replaced;
        }
        catch (UnsupportedEncodingException e) {
            logger.warn("Exception raised while URL decoding [{}]: {}. We return the original value.", (Object)indexName, (Object)e.getMessage());
            return indexName;
        }
    }
}

