/*
 * Decompiled with CFR 0.152.
 */
package fr.pilato.spring.elasticsearch;

import fr.pilato.elasticsearch.tools.alias.AliasElasticsearchUpdater;
import fr.pilato.elasticsearch.tools.index.IndexElasticsearchUpdater;
import fr.pilato.elasticsearch.tools.index.IndexFinder;
import fr.pilato.elasticsearch.tools.template.TemplateElasticsearchUpdater;
import fr.pilato.elasticsearch.tools.template.TemplateFinder;
import fr.pilato.elasticsearch.tools.type.TypeElasticsearchUpdater;
import fr.pilato.elasticsearch.tools.type.TypeFinder;
import fr.pilato.spring.elasticsearch.ElasticsearchAbstractFactoryBean;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class ElasticsearchRestClientFactoryBean
extends ElasticsearchAbstractFactoryBean
implements FactoryBean<RestHighLevelClient>,
InitializingBean,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(ElasticsearchRestClientFactoryBean.class);
    private RestHighLevelClient client;
    private boolean forceMapping;
    private boolean forceTemplate;
    private boolean mergeMapping;
    private boolean mergeSettings = true;
    private boolean autoscan = true;
    private String[] mappings;
    private String[] aliases;
    private String[] templates;
    private String classpathRoot = "es";
    private String[] esNodes = new String[]{"http://localhost:9200"};

    public void setForceMapping(boolean forceMapping) {
        this.forceMapping = forceMapping;
    }

    public void setForceTemplate(boolean forceTemplate) {
        this.forceTemplate = forceTemplate;
    }

    public void setMergeMapping(boolean mergeMapping) {
        this.mergeMapping = mergeMapping;
    }

    public void setMergeSettings(boolean mergeSettings) {
        this.mergeSettings = mergeSettings;
    }

    public void setAutoscan(boolean autoscan) {
        this.autoscan = autoscan;
    }

    public void setMappings(String[] mappings) {
        this.mappings = mappings;
    }

    public void setAliases(String[] aliases) {
        this.aliases = aliases;
    }

    public void setTemplates(String[] templates) {
        this.templates = templates;
    }

    public void setClasspathRoot(String classpathRoot) {
        this.classpathRoot = classpathRoot.startsWith("/") ? classpathRoot.substring(1, classpathRoot.length()) : classpathRoot;
    }

    public void afterPropertiesSet() throws Exception {
        logger.info("Starting Elasticsearch client");
        this.client = this.initialize();
    }

    private RestHighLevelClient initialize() throws Exception {
        this.client = this.buildRestHighLevelClient();
        if (this.autoscan) {
            this.computeMappings();
            this.computeTemplates();
        }
        this.initTemplates();
        this.initMappings();
        this.initAliases();
        return this.client;
    }

    public void destroy() {
        try {
            logger.info("Closing Elasticsearch client");
            if (this.client != null) {
                this.client.close();
            }
        }
        catch (Exception e) {
            logger.error("Error closing Elasticsearch client: ", (Throwable)e);
        }
    }

    public RestHighLevelClient getObject() {
        return this.client;
    }

    public Class<RestHighLevelClient> getObjectType() {
        return RestHighLevelClient.class;
    }

    public boolean isSingleton() {
        return true;
    }

    private void initTemplates() throws Exception {
        if (this.templates != null && this.templates.length > 0) {
            for (String template : this.templates) {
                Assert.hasText((String)template, (String)("Can not read template in [" + template + "]. Check that templates is not empty."));
                TemplateElasticsearchUpdater.createTemplate((RestClient)this.client.getLowLevelClient(), (String)this.classpathRoot, (String)template, (boolean)this.forceTemplate);
            }
        }
    }

    private void computeMappings() {
        if (this.mappings == null || this.mappings.length == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("Automatic discovery is activated. Looking for definition files in classpath under [{}].", (Object)this.classpathRoot);
            }
            ArrayList<String> autoMappings = new ArrayList<String>();
            try {
                List indices = IndexFinder.findIndexNames((String)this.classpathRoot);
                for (String index : indices) {
                    List types = TypeFinder.findTypes((String)this.classpathRoot, (String)index);
                    if (types.isEmpty()) {
                        autoMappings.add(index);
                        continue;
                    }
                    for (String type : types) {
                        autoMappings.add(index + "/" + type);
                    }
                }
                this.mappings = autoMappings.toArray(new String[autoMappings.size()]);
            }
            catch (IOException | URISyntaxException e) {
                logger.debug("Automatic discovery does not succeed for finding json files in classpath under " + this.classpathRoot + ".");
                logger.trace("", (Throwable)e);
            }
        }
    }

    private void computeTemplates() {
        if (this.templates == null || this.templates.length == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("Automatic discovery is activated. Looking for template files in classpath under [{}].", (Object)this.classpathRoot);
            }
            ArrayList<String> autoTemplates = new ArrayList<String>();
            try {
                List scannedTemplates = TemplateFinder.findTemplates((String)this.classpathRoot);
                for (String template : scannedTemplates) {
                    autoTemplates.add(template);
                }
                this.templates = autoTemplates.toArray(new String[autoTemplates.size()]);
            }
            catch (IOException | URISyntaxException e) {
                logger.debug("Automatic discovery does not succeed for finding json files in classpath under " + this.classpathRoot + ".");
                logger.trace("", (Throwable)e);
            }
        }
    }

    private void initMappings() throws Exception {
        this.checkClient();
        if (this.mappings != null && this.mappings.length > 0) {
            Map<String, Collection<String>> indices = ElasticsearchRestClientFactoryBean.getIndexMappings(this.mappings);
            for (String index : indices.keySet()) {
                IndexElasticsearchUpdater.createIndex((RestClient)this.client.getLowLevelClient(), (String)this.classpathRoot, (String)index, (boolean)this.forceMapping);
                if (this.mergeSettings) {
                    IndexElasticsearchUpdater.updateSettings((RestClient)this.client.getLowLevelClient(), (String)this.classpathRoot, (String)index);
                }
                Collection<String> mappings = indices.get(index);
                for (String type : mappings) {
                    TypeElasticsearchUpdater.createMapping((RestClient)this.client.getLowLevelClient(), (String)this.classpathRoot, (String)index, (String)type, (boolean)this.mergeMapping);
                }
            }
        }
    }

    private static Map<String, Collection<String>> getIndexMappings(String[] mappings) throws Exception {
        HashMap<String, Collection<String>> indices = new HashMap<String, Collection<String>>();
        for (String indexmapping : mappings) {
            String[] indexmappingsplitted = indexmapping.split("/");
            String index = indexmappingsplitted[0];
            if (index == null) {
                throw new Exception("Can not read index in [" + indexmapping + "]. Check that mappings contains only indexname/mappingname elements.");
            }
            if (!indices.containsKey(index)) {
                indices.put(index, new ArrayList());
            }
            if (indexmappingsplitted.length <= 1) continue;
            ((Collection)indices.get(index)).add(indexmappingsplitted[1]);
        }
        return indices;
    }

    private void initAliases() throws Exception {
        if (this.aliases != null && this.aliases.length > 0) {
            for (String aliase : this.aliases) {
                String[] aliasessplitted = aliase.split(":");
                String alias = aliasessplitted[0];
                String index = aliasessplitted[1];
                if (index == null) {
                    throw new Exception("Can not read index in [" + aliase + "]. Check that aliases contains only aliasname:indexname elements.");
                }
                if (alias == null) {
                    throw new Exception("Can not read mapping in [" + aliase + "]. Check that aliases contains only aliasname:indexname elements.");
                }
                AliasElasticsearchUpdater.createAlias((RestClient)this.client.getLowLevelClient(), (String)alias, (String)index);
            }
        }
    }

    private void checkClient() throws Exception {
        if (this.client == null) {
            throw new Exception("Elasticsearch client doesn't exist. Your factory is not properly initialized.");
        }
    }

    public void setEsNodes(String[] esNodes) {
        this.esNodes = esNodes;
    }

    private RestHighLevelClient buildRestHighLevelClient() throws Exception {
        String securedUser;
        ArrayList<HttpHost> hosts = new ArrayList<HttpHost>(this.esNodes.length);
        for (String esNode : this.esNodes) {
            hosts.add(HttpHost.create((String)esNode));
        }
        RestClientBuilder rcb = RestClient.builder((HttpHost[])hosts.toArray(new HttpHost[0]));
        String string = securedUser = this.properties != null ? this.properties.getProperty("xpack.security.user", null) : null;
        if (securedUser != null) {
            String[] split = securedUser.split(":");
            if (split.length < 2) {
                throw new IllegalArgumentException("xpack.security.user must have the form username:password");
            }
            String username = split[0];
            String password = split[1];
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
            rcb.setHttpClientConfigCallback(arg_0 -> ElasticsearchRestClientFactoryBean.lambda$buildRestHighLevelClient$0((CredentialsProvider)credentialsProvider, arg_0));
        }
        return new RestHighLevelClient(rcb);
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$buildRestHighLevelClient$0(CredentialsProvider credentialsProvider, HttpAsyncClientBuilder hcb) {
        return hcb.setDefaultCredentialsProvider(credentialsProvider);
    }
}

