/*
 * Decompiled with CFR 0.152.
 */
package fr.pilato.spring.elasticsearch;

import fr.pilato.elasticsearch.tools.alias.AliasElasticsearchUpdater;
import fr.pilato.elasticsearch.tools.index.IndexElasticsearchUpdater;
import fr.pilato.elasticsearch.tools.index.IndexFinder;
import fr.pilato.elasticsearch.tools.template.TemplateElasticsearchUpdater;
import fr.pilato.elasticsearch.tools.template.TemplateFinder;
import fr.pilato.elasticsearch.tools.type.TypeElasticsearchUpdater;
import fr.pilato.elasticsearch.tools.type.TypeFinder;
import fr.pilato.spring.elasticsearch.ElasticsearchAbstractFactoryBean;
import fr.pilato.spring.elasticsearch.proxy.GenericInvocationHandler;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequestBuilder;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequestBuilder;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.cluster.health.ClusterIndexHealth;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.transport.client.PreBuiltTransportClient;
import org.elasticsearch.xpack.client.PreBuiltXPackTransportClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class ElasticsearchTransportClientFactoryBean
extends ElasticsearchAbstractFactoryBean
implements FactoryBean<Client>,
InitializingBean,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(ElasticsearchTransportClientFactoryBean.class);
    private Client client;
    private Client proxyfiedClient;
    private boolean forceMapping;
    private boolean forceTemplate;
    private boolean mergeMapping;
    private boolean mergeSettings = true;
    private boolean autoscan = true;
    private String[] mappings;
    private String[] aliases;
    private String[] templates;
    private String classpathRoot = "es";
    private String[] esNodes = new String[]{"localhost:9300"};
    private String[] plugins = new String[0];

    public void setForceMapping(boolean forceMapping) {
        this.forceMapping = forceMapping;
    }

    public void setForceTemplate(boolean forceTemplate) {
        this.forceTemplate = forceTemplate;
    }

    public void setMergeMapping(boolean mergeMapping) {
        this.mergeMapping = mergeMapping;
    }

    public void setMergeSettings(boolean mergeSettings) {
        this.mergeSettings = mergeSettings;
    }

    public void setAutoscan(boolean autoscan) {
        this.autoscan = autoscan;
    }

    public void setMappings(String[] mappings) {
        this.mappings = mappings;
    }

    public void setAliases(String[] aliases) {
        this.aliases = aliases;
    }

    public void setTemplates(String[] templates) {
        this.templates = templates;
    }

    public void setClasspathRoot(String classpathRoot) {
        this.classpathRoot = classpathRoot.startsWith("/") ? classpathRoot.substring(1, classpathRoot.length()) : classpathRoot;
    }

    public void afterPropertiesSet() throws Exception {
        logger.info("Starting Elasticsearch client");
        if (this.async) {
            Assert.notNull((Object)this.taskExecutor, (String)"taskExecutor can not be null");
            Future future = this.taskExecutor.submit((Callable)new Callable<Client>(){

                @Override
                public Client call() throws Exception {
                    return ElasticsearchTransportClientFactoryBean.this.initialize();
                }
            });
            ProxyFactory proxyFactory = new ProxyFactory();
            proxyFactory.setProxyTargetClass(true);
            proxyFactory.setTargetClass(Client.class);
            proxyFactory.addAdvice(new GenericInvocationHandler(future));
            this.proxyfiedClient = (Client)proxyFactory.getProxy();
        } else {
            this.client = this.initialize();
        }
    }

    private Client initialize() throws Exception {
        this.client = this.buildClient();
        if (this.autoscan) {
            this.computeMappings();
            this.computeTemplates();
        }
        if (this.mappings != null && this.mappings.length > 0) {
            ClusterHealthRequestBuilder healthRequestBuilder = this.client.admin().cluster().prepareHealth(new String[0]).setWaitForYellowStatus();
            ClusterStateRequestBuilder clusterStateRequestBuilder = this.client.admin().cluster().prepareState();
            Map<String, Collection<String>> indices = ElasticsearchTransportClientFactoryBean.getIndexMappings(this.mappings);
            for (String index : indices.keySet()) {
                clusterStateRequestBuilder.setIndices(new String[]{index});
            }
            ClusterStateResponse clusterStateResponse = (ClusterStateResponse)clusterStateRequestBuilder.get();
            boolean checkIndicesStatus = false;
            for (String index : indices.keySet()) {
                if (!clusterStateResponse.getState().getMetaData().indices().containsKey((Object)index)) continue;
                healthRequestBuilder.setIndices(new String[]{index});
                checkIndicesStatus = true;
            }
            if (checkIndicesStatus) {
                logger.debug("we have to check some indices status as they already exist...");
                ClusterHealthResponse healths = (ClusterHealthResponse)healthRequestBuilder.get();
                if (healths.isTimedOut()) {
                    logger.warn("we got a timeout when checking indices status...");
                    if (healths.getIndices() != null) {
                        for (ClusterIndexHealth health : healths.getIndices().values()) {
                            if (health.getStatus() == ClusterHealthStatus.RED) {
                                logger.warn("index [{}] is in RED state", (Object)health.getIndex());
                                continue;
                            }
                            logger.debug("index [{}] is in [{}] state", (Object)health.getIndex(), (Object)health.getStatus().name());
                        }
                    }
                }
            }
        }
        this.initTemplates();
        this.initMappings();
        this.initAliases();
        return this.client;
    }

    public void destroy() throws Exception {
        try {
            logger.info("Closing Elasticsearch client");
            if (this.client != null) {
                this.client.close();
            }
        }
        catch (Exception e) {
            logger.error("Error closing Elasticsearch client: ", (Throwable)e);
        }
    }

    public Client getObject() throws Exception {
        return this.async ? this.proxyfiedClient : this.client;
    }

    public Class<Client> getObjectType() {
        return Client.class;
    }

    public boolean isSingleton() {
        return true;
    }

    private void initTemplates() throws Exception {
        if (this.templates != null && this.templates.length > 0) {
            for (String template : this.templates) {
                Assert.hasText((String)template, (String)("Can not read template in [" + template + "]. Check that templates is not empty."));
                TemplateElasticsearchUpdater.createTemplate((Client)this.client, (String)this.classpathRoot, (String)template, (boolean)this.forceTemplate);
            }
        }
    }

    private void computeMappings() {
        if (this.mappings == null || this.mappings.length == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("Automatic discovery is activated. Looking for definition files in classpath under [{}].", (Object)this.classpathRoot);
            }
            ArrayList<String> autoMappings = new ArrayList<String>();
            try {
                List indices = IndexFinder.findIndexNames((String)this.classpathRoot);
                for (String index : indices) {
                    List types = TypeFinder.findTypes((String)this.classpathRoot, (String)index);
                    if (types.isEmpty()) {
                        autoMappings.add(index);
                        continue;
                    }
                    for (String type : types) {
                        autoMappings.add(index + "/" + type);
                    }
                }
                this.mappings = autoMappings.toArray(new String[autoMappings.size()]);
            }
            catch (IOException | URISyntaxException e) {
                logger.debug("Automatic discovery does not succeed for finding json files in classpath under " + this.classpathRoot + ".");
                logger.trace("", (Throwable)e);
            }
        }
    }

    private void computeTemplates() {
        if (this.templates == null || this.templates.length == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("Automatic discovery is activated. Looking for template files in classpath under [{}].", (Object)this.classpathRoot);
            }
            ArrayList<String> autoTemplates = new ArrayList<String>();
            try {
                List scannedTemplates = TemplateFinder.findTemplates((String)this.classpathRoot);
                for (String template : scannedTemplates) {
                    autoTemplates.add(template);
                }
                this.templates = autoTemplates.toArray(new String[autoTemplates.size()]);
            }
            catch (IOException | URISyntaxException e) {
                logger.debug("Automatic discovery does not succeed for finding json files in classpath under " + this.classpathRoot + ".");
                logger.trace("", (Throwable)e);
            }
        }
    }

    private void initMappings() throws Exception {
        this.checkClient();
        if (this.mappings != null && this.mappings.length > 0) {
            Map<String, Collection<String>> indices = ElasticsearchTransportClientFactoryBean.getIndexMappings(this.mappings);
            for (String index : indices.keySet()) {
                IndexElasticsearchUpdater.createIndex((Client)this.client, (String)this.classpathRoot, (String)index, (boolean)this.forceMapping);
                if (this.mergeSettings) {
                    IndexElasticsearchUpdater.updateSettings((Client)this.client, (String)this.classpathRoot, (String)index);
                }
                Collection<String> mappings = indices.get(index);
                for (String type : mappings) {
                    TypeElasticsearchUpdater.createMapping((Client)this.client, (String)this.classpathRoot, (String)index, (String)type, (boolean)this.mergeMapping);
                }
            }
        }
    }

    private static Map<String, Collection<String>> getIndexMappings(String[] mappings) throws Exception {
        HashMap<String, Collection<String>> indices = new HashMap<String, Collection<String>>();
        for (String indexmapping : mappings) {
            String[] indexmappingsplitted = indexmapping.split("/");
            String index = indexmappingsplitted[0];
            if (index == null) {
                throw new Exception("Can not read index in [" + indexmapping + "]. Check that mappings contains only indexname/mappingname elements.");
            }
            if (!indices.containsKey(index)) {
                indices.put(index, new ArrayList());
            }
            if (indexmappingsplitted.length <= 1) continue;
            ((Collection)indices.get(index)).add(indexmappingsplitted[1]);
        }
        return indices;
    }

    private void initAliases() throws Exception {
        if (this.aliases != null && this.aliases.length > 0) {
            for (String aliase : this.aliases) {
                String[] aliasessplitted = aliase.split(":");
                String alias = aliasessplitted[0];
                String index = aliasessplitted[1];
                if (index == null) {
                    throw new Exception("Can not read index in [" + aliase + "]. Check that aliases contains only aliasname:indexname elements.");
                }
                if (alias == null) {
                    throw new Exception("Can not read mapping in [" + aliase + "]. Check that aliases contains only aliasname:indexname elements.");
                }
                AliasElasticsearchUpdater.createAlias((Client)this.client, (String)alias, (String)index);
            }
        }
    }

    private void checkClient() throws Exception {
        if (this.client == null) {
            throw new Exception("Elasticsearch client doesn't exist. Your factory is not properly initialized.");
        }
    }

    public void setEsNodes(String[] esNodes) {
        this.esNodes = esNodes;
    }

    public void setPlugins(String[] plugins) {
        this.plugins = plugins;
    }

    private Client buildClient() throws Exception {
        PreBuiltXPackTransportClient client;
        String securedUser;
        Settings.Builder settingsBuilder = Settings.builder();
        if (null != this.properties) {
            this.properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> settingsBuilder.put((String)key, (String)value)));
        }
        ArrayList<Class> pluginClasses = new ArrayList<Class>(this.plugins.length);
        for (String plugin : this.plugins) {
            logger.debug("Adding plugin [{}]", (Object)plugin);
            pluginClasses.add(ClassUtils.resolveClassName((String)plugin, (ClassLoader)Thread.currentThread().getContextClassLoader()));
        }
        String string = securedUser = this.properties != null ? this.properties.getProperty("xpack.security.user", null) : null;
        if (securedUser != null) {
            logger.debug("Building a Secured XPack Transport Client");
            client = new PreBuiltXPackTransportClient(settingsBuilder.build(), pluginClasses);
        } else {
            logger.debug("Building a Transport Client");
            client = new PreBuiltTransportClient(settingsBuilder.build(), pluginClasses);
        }
        for (String esNode : this.esNodes) {
            client.addTransportAddress(this.toAddress(esNode));
        }
        return client;
    }

    private TransportAddress toAddress(String address) throws UnknownHostException {
        if (address == null) {
            return null;
        }
        String[] splitted = address.split(":");
        int port = 9300;
        if (splitted.length > 1) {
            port = Integer.parseInt(splitted[1]);
        }
        return new TransportAddress(InetAddress.getByName(splitted[0]), port);
    }
}

