/*
 * Decompiled with CFR 0.152.
 */
package fr.pilato.spring.elasticsearch.xml;

import fr.pilato.spring.elasticsearch.ElasticsearchRestClientFactoryBean;
import fr.pilato.spring.elasticsearch.xml.ClientBeanDefinitionParser;
import fr.pilato.spring.elasticsearch.xml.XMLParserUtil;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

class RestClientBeanDefinitionParser
implements BeanDefinitionParser {
    RestClientBeanDefinitionParser() {
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        String id = XMLParserUtil.getElementStringValue(element, "id");
        String name = XMLParserUtil.getElementStringValue(element, "name");
        String esNodes = XMLParserUtil.getElementStringValue(element, "esNodes");
        String properties = XMLParserUtil.getElementStringValue(element, "properties");
        boolean forceMapping = XMLParserUtil.getElementBooleanValue(element, "forceMapping");
        boolean forceTemplate = XMLParserUtil.getElementBooleanValue(element, "forceTemplate");
        boolean mergeMapping = XMLParserUtil.getElementBooleanValue(element, "mergeMapping");
        boolean mergeSettings = XMLParserUtil.getElementBooleanValue(element, "mergeSettings");
        boolean autoscan = XMLParserUtil.getElementBooleanValue(element, "autoscan", true);
        String classpathRoot = XMLParserUtil.getElementStringValue(element, "classpathRoot");
        String mappings = XMLParserUtil.getElementStringValue(element, "mappings");
        String aliases = XMLParserUtil.getElementStringValue(element, "aliases");
        String templates = XMLParserUtil.getElementStringValue(element, "templates");
        String taskExecutor = XMLParserUtil.getElementStringValue(element, "taskExecutor");
        if (esNodes == null || esNodes.length() == 0) {
            esNodes = "127.0.0.1:9200";
        }
        GenericBeanDefinition bdef = new GenericBeanDefinition();
        bdef.setBeanClass(ElasticsearchRestClientFactoryBean.class);
        BeanDefinitionBuilder clientBuilder = ClientBeanDefinitionParser.startClientBuilder(ElasticsearchRestClientFactoryBean.class, properties, forceMapping, forceTemplate, mergeMapping, mergeSettings, autoscan, classpathRoot, mappings, aliases, templates, null, taskExecutor);
        BeanDefinition client = RestClientBeanDefinitionParser.buildRestClientDef(clientBuilder, esNodes);
        if (id != null && id.length() > 0) {
            parserContext.getRegistry().registerBeanDefinition(id, client);
        } else {
            parserContext.getRegistry().registerBeanDefinition(name, client);
        }
        return bdef;
    }

    private static BeanDefinition buildRestClientDef(BeanDefinitionBuilder nodeFactory, String esNodes) {
        if (esNodes != null && esNodes.length() > 0) {
            nodeFactory.addPropertyValue("esNodes", (Object)esNodes);
        }
        return nodeFactory.getBeanDefinition();
    }
}

