/*
 * Decompiled with CFR 0.152.
 */
package fr.pilato.spring.elasticsearch.xml;

import fr.pilato.spring.elasticsearch.ElasticsearchTransportClientFactoryBean;
import fr.pilato.spring.elasticsearch.xml.ClientBeanDefinitionParser;
import fr.pilato.spring.elasticsearch.xml.XMLParserUtil;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

class TransportClientBeanDefinitionParser
extends ClientBeanDefinitionParser
implements BeanDefinitionParser {
    TransportClientBeanDefinitionParser() {
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        String id = XMLParserUtil.getElementStringValue(element, "id");
        String name = XMLParserUtil.getElementStringValue(element, "name");
        String esNodes = XMLParserUtil.getElementStringValue(element, "esNodes");
        String plugins = XMLParserUtil.getElementStringValue(element, "plugins");
        String properties = XMLParserUtil.getElementStringValue(element, "properties");
        boolean forceMapping = XMLParserUtil.getElementBooleanValue(element, "forceMapping");
        boolean forceTemplate = XMLParserUtil.getElementBooleanValue(element, "forceTemplate");
        boolean mergeMapping = XMLParserUtil.getElementBooleanValue(element, "mergeMapping");
        boolean mergeSettings = XMLParserUtil.getElementBooleanValue(element, "mergeSettings");
        boolean autoscan = XMLParserUtil.getElementBooleanValue(element, "autoscan", true);
        String classpathRoot = XMLParserUtil.getElementStringValue(element, "classpathRoot");
        String mappings = XMLParserUtil.getElementStringValue(element, "mappings");
        String aliases = XMLParserUtil.getElementStringValue(element, "aliases");
        String templates = XMLParserUtil.getElementStringValue(element, "templates");
        String taskExecutor = XMLParserUtil.getElementStringValue(element, "taskExecutor");
        String async = XMLParserUtil.getElementStringValue(element, "async");
        if (esNodes == null || esNodes.length() == 0) {
            esNodes = "127.0.0.1:9300";
        }
        GenericBeanDefinition bdef = new GenericBeanDefinition();
        bdef.setBeanClass(ElasticsearchTransportClientFactoryBean.class);
        BeanDefinitionBuilder clientBuilder = TransportClientBeanDefinitionParser.startClientBuilder(ElasticsearchTransportClientFactoryBean.class, properties, forceMapping, forceTemplate, mergeMapping, mergeSettings, autoscan, classpathRoot, mappings, aliases, templates, async, taskExecutor);
        BeanDefinition client = TransportClientBeanDefinitionParser.buildTransportClientDef(clientBuilder, esNodes, plugins);
        if (id != null && id.length() > 0) {
            parserContext.getRegistry().registerBeanDefinition(id, client);
        } else {
            parserContext.getRegistry().registerBeanDefinition(name, client);
        }
        return bdef;
    }

    private static BeanDefinition buildTransportClientDef(BeanDefinitionBuilder nodeFactory, String esNodes, String plugins) {
        if (esNodes != null && esNodes.length() > 0) {
            nodeFactory.addPropertyValue("esNodes", (Object)esNodes);
        }
        if (plugins != null && plugins.length() > 0) {
            nodeFactory.addPropertyValue("plugins", (Object)plugins);
        }
        return nodeFactory.getBeanDefinition();
    }
}

