/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.algorithm;

import gov.sandia.cognition.algorithm.AbstractIterativeAlgorithm;
import gov.sandia.cognition.algorithm.AnytimeAlgorithm;
import gov.sandia.cognition.algorithm.IterativeAlgorithm;
import gov.sandia.cognition.algorithm.IterativeAlgorithmListener;
import gov.sandia.cognition.util.ObjectUtil;

public abstract class AnytimeAlgorithmWrapper<ResultType, InternalAlgorithm extends AnytimeAlgorithm>
extends AbstractIterativeAlgorithm
implements AnytimeAlgorithm<ResultType>,
IterativeAlgorithmListener {
    private InternalAlgorithm algorithm;

    public AnytimeAlgorithmWrapper() {
        this(null);
    }

    public AnytimeAlgorithmWrapper(InternalAlgorithm algorithm) {
        this.setAlgorithm(algorithm);
    }

    @Override
    public AnytimeAlgorithmWrapper<ResultType, InternalAlgorithm> clone() {
        AnytimeAlgorithmWrapper clone = (AnytimeAlgorithmWrapper)super.clone();
        clone.setAlgorithm((AnytimeAlgorithm)ObjectUtil.cloneSmart(this.getAlgorithm()));
        return clone;
    }

    @Override
    public int getMaxIterations() {
        return this.algorithm.getMaxIterations();
    }

    @Override
    public void setMaxIterations(int maxIterations) {
        this.algorithm.setMaxIterations(maxIterations);
    }

    public InternalAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(InternalAlgorithm algorithm) {
        if (this.algorithm != null) {
            this.algorithm.removeIterativeAlgorithmListener(this);
        }
        this.algorithm = algorithm;
        if (this.algorithm != null) {
            this.algorithm.addIterativeAlgorithmListener(this);
        }
    }

    @Override
    public void stop() {
        if (this.getAlgorithm() != null) {
            this.getAlgorithm().stop();
        }
    }

    @Override
    public int getIteration() {
        return this.getAlgorithm().getIteration();
    }

    @Override
    public boolean isResultValid() {
        return this.getResult() != null;
    }

    @Override
    public void algorithmStarted(IterativeAlgorithm algorithm) {
        this.fireAlgorithmStarted();
    }

    @Override
    public void algorithmEnded(IterativeAlgorithm algorithm) {
        this.fireAlgorithmEnded();
    }

    @Override
    public void stepStarted(IterativeAlgorithm algorithm) {
        this.fireStepStarted();
    }

    @Override
    public void stepEnded(IterativeAlgorithm algorithm) {
        this.fireStepEnded();
    }

    protected Object readResolve() {
        if (this.algorithm != null) {
            this.algorithm.removeIterativeAlgorithmListener(this);
            this.algorithm.addIterativeAlgorithmListener(this);
        }
        return this;
    }
}

