/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.collection;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.annotation.CodeReviewResponse;
import gov.sandia.cognition.annotation.CodeReviews;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import gov.sandia.cognition.util.CloneableSerializable;
import gov.sandia.cognition.util.ObjectUtil;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.RandomAccess;
import java.util.Set;

@CodeReviews(reviews={@CodeReview(reviewer={"Kevin R. Dixon"}, date="2008-02-08", changesNeeded=true, comments={"I like the added class comment describing the running times.  This may be sufficient.", "However, I would still like to see running times on each accessor method. Please review."}, response={@CodeReviewResponse(respondent="Justin Basilico", date="2008-02-18", moreChangesNeeded=false, comments={"Added running times to each accessor method."})}), @CodeReview(reviewer={"Kevin R. Dixon"}, date="2006-07-18", changesNeeded=true, comments={"Non-standard use of direct-member access, instead of getters and setters. Please review.", "Please add operation running times in class comments like Java does for its LinkedList, HashMap, etc.", "In other news, I fixed some minor spacing and made some logical statements use parentheses to make their precedence clear."}, response={@CodeReviewResponse(respondent="Justin Basilico", date="2006-09-22", moreChangesNeeded=false, comments={"Added comment regarding lack of getters and setters"})})})
public class DynamicArrayMap<ValueType>
extends AbstractMap<Integer, ValueType>
implements CloneableSerializable,
RandomAccess {
    public static final int DEFAULT_INITIAL_CAPACITY = 10;
    private ValueType[] array;
    private int numValues;

    public DynamicArrayMap() {
        this(10);
    }

    public DynamicArrayMap(int initialCapacity) {
        if (initialCapacity <= 0) {
            throw new IllegalArgumentException("The initialCapacity must be positive.");
        }
        this.array = new Object[initialCapacity];
        this.numValues = 0;
    }

    public DynamicArrayMap(DynamicArrayMap<? extends ValueType> other) {
        this.array = new Object[other.array.length];
        System.arraycopy(other.array, 0, this.array, 0, this.array.length);
        this.numValues = other.numValues;
    }

    @Override
    public DynamicArrayMap<ValueType> clone() {
        DynamicArrayMap clone = null;
        try {
            clone = (DynamicArrayMap)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
        int num = this.array.length;
        clone.array = new Object[num];
        System.arraycopy(this.array, 0, clone.array, 0, num);
        return clone;
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.array.length; ++i) {
            this.array[i] = null;
        }
        this.numValues = 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return key != null && key instanceof Integer && this.containsKey((Integer)key);
    }

    public boolean containsKey(int key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            return false;
        }
        for (int i = 0; i < this.array.length; ++i) {
            ValueType entry = this.array[i];
            if (entry == null || !value.equals(entry)) continue;
            return true;
        }
        return false;
    }

    public void ensureCapacity(int minCapacity) {
        int currentCapacity = this.array.length;
        if (currentCapacity < minCapacity) {
            int newCapacity = currentCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            Object[] newArray = new Object[newCapacity];
            System.arraycopy(this.array, 0, newArray, 0, currentCapacity);
            this.array = newArray;
        }
    }

    @Override
    public Set<Map.Entry<Integer, ValueType>> entrySet() {
        return new EntrySet();
    }

    @Override
    public ValueType get(Object key) {
        if (key == null) {
            throw new NullPointerException("The key cannot be null");
        }
        if (key instanceof Integer) {
            return this.get((Integer)key);
        }
        return null;
    }

    public ValueType get(int key) {
        if (key >= this.array.length) {
            return null;
        }
        return this.array[key];
    }

    @Override
    public boolean isEmpty() {
        return this.numValues <= 0;
    }

    @Override
    public Set<Integer> keySet() {
        return super.keySet();
    }

    @Override
    public ValueType put(Integer key, ValueType value) {
        return this.put((int)key, value);
    }

    @Override
    public ValueType put(int key, ValueType value) {
        boolean newNull;
        ValueType oldValue = null;
        if (key < this.array.length) {
            oldValue = this.array[key];
            this.array[key] = value;
        } else if (value != null) {
            this.ensureCapacity(key + 1);
            this.array[key] = value;
        } else {
            return null;
        }
        boolean oldNull = oldValue == null;
        boolean bl = newNull = value == null;
        if (oldNull && !newNull) {
            ++this.numValues;
        } else if (!oldNull && newNull) {
            --this.numValues;
        }
        return oldValue;
    }

    @Override
    public ValueType remove(Object key) {
        if (key == null) {
            throw new NullPointerException("The key cannot be null");
        }
        if (key instanceof Integer) {
            return this.remove((Integer)key);
        }
        return null;
    }

    public ValueType remove(int key) {
        if (key < this.array.length) {
            ValueType result = this.array[key];
            this.array[key] = null;
            if (result != null) {
                --this.numValues;
            }
            return result;
        }
        return null;
    }

    @Override
    public int size() {
        return this.numValues;
    }

    @Override
    public Collection<ValueType> values() {
        return new ValuesCollection();
    }

    private class Entry
    implements Map.Entry<Integer, ValueType> {
        private int index;
        private ValueType value;

        private Entry(int index, ValueType value) {
            this.index = index;
            this.value = value;
        }

        @Override
        public Integer getKey() {
            return this.index;
        }

        @Override
        public ValueType getValue() {
            return this.value;
        }

        @Override
        public ValueType setValue(ValueType value) {
            Object oldValue = this.value;
            this.value = value;
            DynamicArrayMap.this.put(this.index, value);
            return oldValue;
        }

        @Override
        public boolean equals(Object other) {
            return other instanceof Entry && this.equals((Entry)other);
        }

        public boolean equals(Entry other) {
            return this.index == other.index && ObjectUtil.equalsSafe(this.value, other.value);
        }

        @Override
        public int hashCode() {
            return this.index ^ (this.value == null ? 0 : this.value.hashCode());
        }
    }

    private class EntryIterator
    extends AbstractCloneableSerializable
    implements Iterator<Map.Entry<Integer, ValueType>> {
        private ValuesIterator iterator = null;

        private EntryIterator() {
            this.iterator = new ValuesIterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Map.Entry<Integer, ValueType> next() {
            int index = this.iterator.peekNextIndex();
            Object value = this.iterator.next();
            return new Entry(index, value);
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<Integer, ValueType>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<Integer, ValueType>> iterator() {
            return new EntryIterator();
        }

        @Override
        public int size() {
            return DynamicArrayMap.this.size();
        }
    }

    private class ValuesCollection
    extends AbstractCollection<ValueType> {
        private ValuesCollection() {
        }

        @Override
        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (other instanceof Collection) {
                return this.equals((Collection)other);
            }
            return false;
        }

        public boolean equals(Collection other) {
            if (other == null) {
                return false;
            }
            if (this.size() != other.size()) {
                return false;
            }
            Iterator thisIt = this.iterator();
            Iterator otherIt = other.iterator();
            boolean keepGoing = true;
            while (keepGoing) {
                boolean otherHasNext;
                boolean thisHasNext = thisIt.hasNext();
                if (thisHasNext != (otherHasNext = otherIt.hasNext())) {
                    return false;
                }
                if (thisHasNext) {
                    Object thisNext = thisIt.next();
                    Object otherNext = otherIt.next();
                    if (thisNext == null && otherNext == null || thisNext != null && thisNext.equals(otherNext)) {
                        keepGoing = true;
                        continue;
                    }
                    return false;
                }
                keepGoing = false;
            }
            return true;
        }

        @Override
        public Iterator<ValueType> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int size() {
            return DynamicArrayMap.this.size();
        }

        @Override
        public int hashCode() {
            int hash = 7;
            return 7;
        }
    }

    private class ValuesIterator
    extends AbstractCloneableSerializable
    implements Iterator<ValueType> {
        private int cursor = -1;
        private ValueType next;

        public ValuesIterator() {
            this.findNextNonNull();
        }

        private void findNextNonNull() {
            this.next = null;
            while (this.next == null && this.cursor - 1 < DynamicArrayMap.this.array.length) {
                ++this.cursor;
                this.next = DynamicArrayMap.this.get(this.cursor);
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        public int peekNextIndex() {
            return this.cursor;
        }

        @Override
        public ValueType next() {
            Object result = this.next;
            this.findNextNonNull();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

