/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.evaluator;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.evaluator.Evaluator;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import gov.sandia.cognition.util.ObjectUtil;
import java.io.Serializable;

@CodeReview(reviewer={"Kevin R. Dixon"}, date="2008-12-02", changesNeeded=false, comments={"Looks good... very clever and clear implementation."})
public class ValueClamper<DataType extends Comparable<DataType>>
extends AbstractCloneableSerializable
implements Evaluator<DataType, DataType>,
Serializable {
    private DataType minimum;
    private DataType maximum;

    public ValueClamper() {
        this(null, null);
    }

    public ValueClamper(DataType minimum, DataType maximum) {
        this.setMinimum(minimum);
        this.setMaximum(maximum);
    }

    @Override
    public ValueClamper<DataType> clone() {
        ValueClamper result = (ValueClamper)super.clone();
        result.minimum = (Comparable)ObjectUtil.cloneSmart(this.minimum);
        result.maximum = (Comparable)ObjectUtil.cloneSmart(this.maximum);
        return result;
    }

    @Override
    public DataType evaluate(DataType input) {
        if (input == null) {
            return null;
        }
        if (this.minimum != null && input.compareTo(this.minimum) < 0) {
            return this.minimum;
        }
        if (this.maximum != null && input.compareTo(this.maximum) > 0) {
            return this.maximum;
        }
        return input;
    }

    public DataType getMinimum() {
        return this.minimum;
    }

    public void setMinimum(DataType minimum) {
        this.minimum = minimum;
    }

    public DataType getMaximum() {
        return this.maximum;
    }

    public void setMaximum(DataType maximum) {
        this.maximum = maximum;
    }
}

