/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.io;

import gov.sandia.cognition.io.ProcessLauncherEvent;
import gov.sandia.cognition.io.ProcessLauncherListener;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedList;

public class ProcessLauncher
extends Thread {
    private String actualCommand;
    private Process process;
    private LinkedList<ProcessLauncherListener> listeners;
    private StreamGobbler stdout;
    private StreamGobbler stderr;

    public ProcessLauncher(String command) {
        String osName = System.getProperty("os.name");
        if (osName.equals("Windows XP")) {
            this.setActualCommand("cmd.exe /C \"" + command + "\"");
        } else {
            this.setActualCommand(command);
        }
        this.setProcess(null);
        this.stdout = null;
        this.stderr = null;
        this.listeners = new LinkedList();
    }

    @Override
    public void run() {
        try {
            System.out.println("Executing: " + this.getActualCommand());
            this.setProcess(Runtime.getRuntime().exec(this.getActualCommand()));
            this.stdout = new StreamGobbler(this.getProcess().getInputStream(), ProcessLauncherEvent.EventType.STDOUT);
            this.stdout.start();
            this.stderr = new StreamGobbler(this.getProcess().getErrorStream(), ProcessLauncherEvent.EventType.STDERR);
            this.stderr.start();
            this.getProcess().waitFor();
            this.fireEvent(new ProcessLauncherEvent(ProcessLauncherEvent.EventType.FINISHED, null, this.getProcess()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void addListener(ProcessLauncherListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ProcessLauncherListener listener) {
        this.listeners.remove(listener);
    }

    private void fireEvent(ProcessLauncherEvent event) {
        for (ProcessLauncherListener listener : this.listeners) {
            listener.processLauncherEvent(event);
        }
    }

    public void stopProcess() {
        if (this.getProcess() != null) {
            this.getProcess().destroy();
            this.setProcess(null);
        }
        if (this.stdout != null) {
            this.stdout.interrupt();
            this.stdout = null;
        }
        if (this.stderr != null) {
            this.stderr.interrupt();
            this.stdout = null;
        }
        this.interrupt();
    }

    public Process getProcess() {
        return this.process;
    }

    protected void setProcess(Process process) {
        this.process = process;
    }

    public String getActualCommand() {
        return this.actualCommand;
    }

    protected void setActualCommand(String actualCommand) {
        this.actualCommand = actualCommand;
    }

    private class StreamGobbler
    extends Thread {
        InputStream stream;
        ProcessLauncherEvent.EventType type;

        StreamGobbler(InputStream stream, ProcessLauncherEvent.EventType type) {
            this.stream = stream;
            this.type = type;
        }

        @Override
        public void run() {
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(this.stream));
            try {
                String line;
                while ((line = stdInput.readLine()) != null) {
                    ProcessLauncher.this.fireEvent(new ProcessLauncherEvent(this.type, line, null));
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

