/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.math;

import gov.sandia.cognition.math.Ring;
import gov.sandia.cognition.math.RingAccumulator;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import gov.sandia.cognition.util.Summarizer;
import gov.sandia.cognition.util.WeightedValue;
import java.util.Collection;

public class WeightedRingAverager<RingType extends Ring<RingType>>
extends AbstractCloneableSerializable
implements Summarizer<WeightedValue<RingType>, RingType> {
    @Override
    public RingType summarize(Collection<? extends WeightedValue<RingType>> data) {
        double weightSum = 0.0;
        RingAccumulator weightedSum = new RingAccumulator();
        for (WeightedValue<RingType> value : data) {
            double w = value.getWeight();
            weightSum += w;
            weightedSum.accumulate(((Ring)value.getValue()).scale(w));
        }
        return weightedSum.getSum().scale(1.0 / weightSum);
    }
}

