/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.math.matrix;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.annotation.CodeReviewResponse;
import gov.sandia.cognition.math.matrix.EntryIndexComparator;
import gov.sandia.cognition.math.matrix.MatrixEntry;
import gov.sandia.cognition.math.matrix.TwoMatrixEntry;
import java.util.Iterator;
import java.util.NoSuchElementException;

@CodeReview(reviewer={"Jonathan McClain"}, date="2006-05-16", changesNeeded=false, comments={"A few comments, marked with triple slashes"}, response={@CodeReviewResponse(respondent="Kevin R. Dixon", date="2006-05-18", moreChangesNeeded=false, comments={"Fixes from J.T.'s code review"})})
public class MatrixUnionIterator
implements Iterator<TwoMatrixEntry> {
    private Iterator<MatrixEntry> firstIterator;
    private Iterator<MatrixEntry> secondIterator;
    private TwoMatrixEntry internalEntry;
    private MatrixEntry firstInternalEntry;
    private MatrixEntry secondInternalEntry;
    private EntryIndexComparator<MatrixEntry> indexComparator = null;

    public MatrixUnionIterator(Iterator<MatrixEntry> firstIterator, Iterator<MatrixEntry> secondIterator, TwoMatrixEntry internalEntry, EntryIndexComparator<MatrixEntry> indexComparator) {
        this.setFirstIterator(firstIterator);
        this.setSecondIterator(secondIterator);
        this.setInternalEntry(internalEntry);
        this.setFirstInternalEntry(null);
        this.setSecondInternalEntry(null);
        this.setIndexComparator(indexComparator);
    }

    public Iterator<MatrixEntry> getFirstIterator() {
        return this.firstIterator;
    }

    public void setFirstIterator(Iterator<MatrixEntry> firstIterator) {
        this.firstIterator = firstIterator;
    }

    public Iterator<MatrixEntry> getSecondIterator() {
        return this.secondIterator;
    }

    public void setSecondIterator(Iterator<MatrixEntry> secondIterator) {
        this.secondIterator = secondIterator;
    }

    public MatrixEntry getFirstInternalEntry() {
        return this.firstInternalEntry;
    }

    public void setFirstInternalEntry(MatrixEntry firstInternalEntry) {
        this.firstInternalEntry = firstInternalEntry;
    }

    public MatrixEntry getSecondInternalEntry() {
        return this.secondInternalEntry;
    }

    public void setSecondInternalEntry(MatrixEntry secondInternalEntry) {
        this.secondInternalEntry = secondInternalEntry;
    }

    public TwoMatrixEntry getInternalEntry() {
        return this.internalEntry;
    }

    public void setInternalEntry(TwoMatrixEntry internalEntry) {
        this.internalEntry = internalEntry;
    }

    public EntryIndexComparator<MatrixEntry> getIndexComparator() {
        return this.indexComparator;
    }

    protected void setIndexComparator(EntryIndexComparator<MatrixEntry> indexComparator) {
        this.indexComparator = indexComparator;
    }

    public boolean safeFirstNext() {
        boolean valid_next;
        try {
            this.setFirstInternalEntry(this.getFirstIterator().next());
            valid_next = true;
        }
        catch (Exception e) {
            this.setFirstInternalEntry(null);
            valid_next = false;
        }
        return valid_next;
    }

    public boolean safeSecondNext() {
        boolean valid_next;
        try {
            this.setSecondInternalEntry(this.getSecondIterator().next());
            valid_next = true;
        }
        catch (Exception e) {
            this.setSecondInternalEntry(null);
            valid_next = false;
        }
        return valid_next;
    }

    protected void advanceInternalIterators() {
        boolean advance_first = false;
        boolean advance_second = false;
        EntryIndexComparator.Compare compare = this.getIndexComparator().lowestIndex(this.getFirstInternalEntry(), this.getSecondInternalEntry());
        if (compare == EntryIndexComparator.Compare.FIRST_LOWEST) {
            advance_first = true;
        } else if (compare == EntryIndexComparator.Compare.SECOND_LOWEST) {
            advance_second = true;
        } else if (compare == EntryIndexComparator.Compare.FIRST_ENTRY_NULL) {
            advance_second = true;
        } else if (compare == EntryIndexComparator.Compare.SECOND_ENTRY_NULL) {
            advance_first = true;
        } else if (compare == EntryIndexComparator.Compare.BOTH_ENTRIES_NULL) {
            advance_first = true;
            advance_second = true;
        } else if (compare == EntryIndexComparator.Compare.ENTRIES_EQUAL) {
            advance_first = true;
            advance_second = true;
        } else {
            throw new NoSuchElementException("Unknown Compare Enum: " + (Object)((Object)compare));
        }
        if (!advance_first && !advance_second) {
            throw new NoSuchElementException("Problem: Not advancing any iterators...");
        }
        if (advance_first) {
            this.safeFirstNext();
        }
        if (advance_second) {
            this.safeSecondNext();
        }
    }

    @Override
    public boolean hasNext() {
        return this.getFirstIterator().hasNext() || this.getSecondIterator().hasNext();
    }

    @Override
    public TwoMatrixEntry next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No elements remaining.");
        }
        this.advanceInternalIterators();
        EntryIndexComparator.Compare compare = this.getIndexComparator().lowestIndex(this.getFirstInternalEntry(), this.getSecondInternalEntry());
        if (compare == EntryIndexComparator.Compare.ENTRIES_EQUAL) {
            this.getInternalEntry().setRowIndex(this.getFirstInternalEntry().getRowIndex());
            this.getInternalEntry().setColumnIndex(this.getFirstInternalEntry().getColumnIndex());
        } else if (compare == EntryIndexComparator.Compare.FIRST_LOWEST) {
            this.getInternalEntry().setRowIndex(this.getFirstInternalEntry().getRowIndex());
            this.getInternalEntry().setColumnIndex(this.getFirstInternalEntry().getColumnIndex());
        } else if (compare == EntryIndexComparator.Compare.SECOND_LOWEST) {
            this.getInternalEntry().setRowIndex(this.getSecondInternalEntry().getRowIndex());
            this.getInternalEntry().setColumnIndex(this.getSecondInternalEntry().getColumnIndex());
        } else if (compare == EntryIndexComparator.Compare.FIRST_ENTRY_NULL) {
            this.getInternalEntry().setRowIndex(this.getSecondInternalEntry().getRowIndex());
            this.getInternalEntry().setColumnIndex(this.getSecondInternalEntry().getColumnIndex());
        } else if (compare == EntryIndexComparator.Compare.SECOND_ENTRY_NULL) {
            this.getInternalEntry().setRowIndex(this.getFirstInternalEntry().getRowIndex());
            this.getInternalEntry().setColumnIndex(this.getFirstInternalEntry().getColumnIndex());
        } else {
            throw new NoSuchElementException("No elements remaining.");
        }
        return this.getInternalEntry();
    }

    @Override
    public void remove() throws UnsupportedOperationException, NoSuchElementException {
        throw new UnsupportedOperationException("Remove is not supported");
    }
}

