/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.math.matrix;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.evaluator.Evaluator;
import gov.sandia.cognition.math.DifferentiableEvaluator;
import gov.sandia.cognition.math.matrix.Matrix;
import gov.sandia.cognition.math.matrix.MatrixFactory;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFactory;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import gov.sandia.cognition.util.ObjectUtil;

@PublicationReference(author={"Wikipedia"}, title="Numerical differentiation", type=PublicationType.WebPage, url="http://en.wikipedia.org/wiki/Numerical_differentiation", year=2008)
public abstract class NumericalDifferentiator<InputType, OutputType, DerivativeType>
extends AbstractCloneableSerializable
implements DifferentiableEvaluator<InputType, OutputType, DerivativeType> {
    static final double DEFAULT_DELTA = 1.0E-10;
    private double delta;
    private Evaluator<InputType, OutputType> internalFunction;

    public NumericalDifferentiator(Evaluator<InputType, OutputType> internalFunction, double delta) {
        this.setInternalFunction(internalFunction);
        this.setDelta(delta);
    }

    @Override
    public NumericalDifferentiator<InputType, OutputType, DerivativeType> clone() {
        NumericalDifferentiator clone = (NumericalDifferentiator)super.clone();
        clone.setInternalFunction(ObjectUtil.cloneSmart(this.getInternalFunction()));
        return clone;
    }

    public Evaluator<InputType, OutputType> getInternalFunction() {
        return this.internalFunction;
    }

    public void setInternalFunction(Evaluator<InputType, OutputType> internalFunction) {
        this.internalFunction = internalFunction;
    }

    public double getDelta() {
        return this.delta;
    }

    public void setDelta(double delta) {
        if (delta <= 0.0) {
            throw new IllegalArgumentException("delta must be > 0.0");
        }
        this.delta = delta;
    }

    @Override
    public OutputType evaluate(InputType input) {
        return this.getInternalFunction().evaluate(input);
    }

    public static class MatrixJacobian
    extends NumericalDifferentiator<Vector, Vector, Matrix> {
        public MatrixJacobian() {
            this(null);
        }

        public MatrixJacobian(Evaluator<Vector, Vector> internalFunction) {
            this(internalFunction, 1.0E-10);
        }

        public MatrixJacobian(Evaluator<Vector, Vector> internalFunction, double delta) {
            super(internalFunction, delta);
        }

        public static Matrix differentiate(Vector input, Evaluator<Vector, Vector> f) {
            return MatrixJacobian.differentiate(input, f, 1.0E-10);
        }

        public static Matrix differentiate(Vector input, Evaluator<Vector, Vector> f, double h) {
            Vector forig = f.evaluate(input);
            Vector inputPlusDeltaj = input.clone();
            int M = forig.getDimensionality();
            int N = input.getDimensionality();
            Matrix J = MatrixFactory.getDefault().createMatrix(M, N);
            for (int j = 0; j < N; ++j) {
                double inputj = input.getElement(j);
                inputPlusDeltaj.setElement(j, inputj + h);
                Vector fj = f.evaluate(inputPlusDeltaj);
                for (int i = 0; i < M; ++i) {
                    double Jij = (fj.getElement(i) - forig.getElement(i)) / h;
                    J.setElement(i, j, Jij);
                }
                inputPlusDeltaj.setElement(j, inputj);
            }
            return J;
        }

        @Override
        public Matrix differentiate(Vector input) {
            return MatrixJacobian.differentiate(input, this.getInternalFunction(), this.getDelta());
        }
    }

    public static class VectorJacobian
    extends NumericalDifferentiator<Vector, Double, Vector> {
        public VectorJacobian() {
            this(null);
        }

        public VectorJacobian(Evaluator<Vector, Double> internalFunction) {
            this(internalFunction, 1.0E-10);
        }

        public VectorJacobian(Evaluator<Vector, Double> internalFunction, double delta) {
            super(internalFunction, delta);
        }

        public static Vector differentiate(Vector input, Evaluator<Vector, Double> f) {
            return VectorJacobian.differentiate(input, f, 1.0E-10);
        }

        public static Vector differentiate(Vector input, Evaluator<Vector, Double> f, double h) {
            double forig = f.evaluate(input);
            Vector inputPlusDeltai = input.clone();
            int M = input.getDimensionality();
            Vector J = VectorFactory.getDefault().createVector(M);
            for (int i = 0; i < M; ++i) {
                double inputi = input.getElement(i);
                inputPlusDeltai.setElement(i, inputi + h);
                double fi = f.evaluate(inputPlusDeltai);
                double di = (fi - forig) / h;
                inputPlusDeltai.setElement(i, inputi);
                J.setElement(i, di);
            }
            return J;
        }

        @Override
        public Vector differentiate(Vector input) {
            return VectorJacobian.differentiate(input, this.getInternalFunction(), this.getDelta());
        }
    }

    public static class DoubleJacobian
    extends NumericalDifferentiator<Double, Double, Double> {
        public DoubleJacobian() {
            this(null);
        }

        public DoubleJacobian(Evaluator<Double, Double> internalFunction) {
            this(internalFunction, 1.0E-10);
        }

        public DoubleJacobian(Evaluator<Double, Double> internalFunction, double delta) {
            super(internalFunction, delta);
        }

        public static Double differentiate(double input, Evaluator<Double, Double> f) {
            return DoubleJacobian.differentiate(input, f, 1.0E-10);
        }

        public static Double differentiate(double input, Evaluator<Double, Double> f, double h) {
            double forig = f.evaluate(input);
            double fdelta = f.evaluate(input + h);
            return (fdelta - forig) / h;
        }

        @Override
        public Double differentiate(Double input) {
            return DoubleJacobian.differentiate(input, this.getInternalFunction(), this.getDelta());
        }
    }
}

