/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.math.matrix.mtj;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.math.ComplexNumber;
import gov.sandia.cognition.math.matrix.DiagonalMatrix;
import gov.sandia.cognition.math.matrix.Matrix;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.mtj.AbstractMTJMatrix;
import gov.sandia.cognition.math.matrix.mtj.AbstractMTJVector;
import gov.sandia.cognition.math.matrix.mtj.DenseMatrix;
import gov.sandia.cognition.math.matrix.mtj.DenseMatrixFactoryMTJ;
import gov.sandia.cognition.math.matrix.mtj.DenseVector;
import gov.sandia.cognition.math.matrix.mtj.DenseVectorFactoryMTJ;
import gov.sandia.cognition.math.matrix.mtj.SparseMatrix;
import gov.sandia.cognition.math.matrix.mtj.SparseMatrixFactoryMTJ;
import gov.sandia.cognition.math.matrix.mtj.SparseVectorFactoryMTJ;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.NumberFormat;
import no.uib.cipr.matrix.BandMatrix;

@PublicationReference(author={"Bjorn-Ove Heimsund"}, title="Matrix Toolkits for Java BandMatrix", type=PublicationType.WebPage, year=2006, url="http://ressim.berlios.de/doc/no/uib/cipr/matrix/BandMatrix.html", notes={"This class wraps the BandMatrix class from Heimsund's MTJ package"})
public class DiagonalMatrixMTJ
extends AbstractMTJMatrix
implements DiagonalMatrix {
    protected DiagonalMatrixMTJ(int dim) {
        super((no.uib.cipr.matrix.Matrix)new BandMatrix(dim, 0, 0));
    }

    protected DiagonalMatrixMTJ(DiagonalMatrixMTJ other) {
        super((no.uib.cipr.matrix.Matrix)other.getInternalMatrix().copy());
    }

    protected DiagonalMatrixMTJ(double[] diagonal) {
        this(diagonal.length);
        double[] actual = this.getDiagonal();
        for (int i = 0; i < diagonal.length; ++i) {
            actual[i] = diagonal[i];
        }
    }

    @Override
    public int getDimensionality() {
        return this.getNumRows();
    }

    public BandMatrix getInternalMatrix() {
        return (BandMatrix)super.getInternalMatrix();
    }

    @Override
    protected void setInternalMatrix(no.uib.cipr.matrix.Matrix internalMatrix) {
        super.setInternalMatrix((no.uib.cipr.matrix.Matrix)((BandMatrix)internalMatrix));
    }

    @Override
    public AbstractMTJMatrix times(AbstractMTJMatrix matrix) {
        if (!this.checkMultiplicationDimensions(matrix)) {
            throw new IllegalArgumentException("Number of columns of this != number of rows of matrix");
        }
        int M = this.getNumRows();
        int N = matrix.getNumColumns();
        DenseMatrix retval = DenseMatrixFactoryMTJ.INSTANCE.createMatrix(M, N);
        double[] diagonal = this.getDiagonal();
        for (int i = 0; i < M; ++i) {
            double di = diagonal[i];
            if (di == 0.0) continue;
            for (int j = 0; j < N; ++j) {
                double vij = matrix.getElement(i, j);
                if (vij == 0.0) continue;
                retval.setElement(i, j, di * vij);
            }
        }
        return retval;
    }

    @Override
    public AbstractMTJVector times(AbstractMTJVector vector) {
        int M = this.getDimensionality();
        if (M != vector.getDimensionality()) {
            throw new IllegalArgumentException("Number of Columns != vector.getDimensionality()");
        }
        double[] diagonal = this.getDiagonal();
        double[] retval = new double[diagonal.length];
        for (int i = 0; i < M; ++i) {
            double v1;
            double v2 = diagonal[i];
            if (v2 == 0.0 || (v1 = vector.getElement(i)) == 0.0) continue;
            retval[i] = v1 * v2;
        }
        return DenseVectorFactoryMTJ.INSTANCE.copyArray(retval);
    }

    @Override
    public DiagonalMatrixMTJ dotTimes(Matrix matrix) {
        DiagonalMatrixMTJ clone = (DiagonalMatrixMTJ)this.clone();
        clone.dotTimesEquals(matrix);
        return clone;
    }

    @Override
    public void dotTimesEquals(AbstractMTJMatrix matrix) {
        this.assertSameDimensions(matrix);
        int M = this.getDimensionality();
        double[] diagonal = this.getDiagonal();
        for (int i = 0; i < M; ++i) {
            int n = i;
            diagonal[n] = diagonal[n] * matrix.getElement(i, i);
        }
    }

    @Override
    public boolean isSquare() {
        return true;
    }

    @Override
    public boolean isSymmetric() {
        return true;
    }

    @Override
    public boolean isSymmetric(double effectiveZero) {
        return true;
    }

    @Override
    public ComplexNumber logDeterminant() {
        double logsum = 0.0;
        int sign = 1;
        double[] diagonal = this.getDiagonal();
        for (int i = 0; i < diagonal.length; ++i) {
            double eigenvalue = diagonal[i];
            if (eigenvalue < 0.0) {
                sign = -sign;
                logsum += Math.log(-eigenvalue);
                continue;
            }
            logsum += Math.log(eigenvalue);
        }
        return new ComplexNumber(logsum, sign < 0 ? Math.PI : 0.0);
    }

    @Override
    public double normFrobenius() {
        double[] diagonal = this.getDiagonal();
        double sum = 0.0;
        for (int i = 0; i < diagonal.length; ++i) {
            double v = diagonal[i];
            sum += v * v;
        }
        return Math.sqrt(sum);
    }

    @Override
    public int rank(double effectiveZero) {
        int rank = 0;
        double[] diagonal = this.getDiagonal();
        int M = diagonal.length;
        for (int i = 0; i < M; ++i) {
            if (!(Math.abs(diagonal[i]) > effectiveZero)) continue;
            ++rank;
        }
        return rank;
    }

    @Override
    public Vector solve(AbstractMTJVector b) {
        DiagonalMatrixMTJ pinvA = this.pseudoInverse();
        return pinvA.times(b);
    }

    @Override
    public Matrix solve(Matrix B) {
        DiagonalMatrixMTJ pinvA = this.pseudoInverse();
        return pinvA.times(B);
    }

    @Override
    public Vector solve(Vector b) {
        DiagonalMatrixMTJ pinvA = this.pseudoInverse();
        return pinvA.times(b);
    }

    @Override
    public SparseMatrix getSubMatrix(int minRow, int maxRow, int minColumn, int maxColumn) {
        int numRows = maxRow - minRow + 1;
        if (numRows <= 0) {
            throw new IllegalArgumentException("minRow " + minRow + " >= maxRow " + maxRow);
        }
        int numColumns = maxColumn - minColumn + 1;
        if (numColumns <= 0) {
            throw new IllegalArgumentException("minCol " + minColumn + " >= maxCol " + maxColumn);
        }
        SparseMatrix submatrix = SparseMatrixFactoryMTJ.INSTANCE.createMatrix(numRows, numColumns);
        this.getSubMatrixInto(minRow, maxRow, minColumn, maxColumn, submatrix);
        return submatrix;
    }

    @Override
    public DiagonalMatrixMTJ transpose() {
        return this;
    }

    @Override
    public double[] getDiagonal() {
        return this.getInternalMatrix().getData();
    }

    @Override
    public DiagonalMatrixMTJ pseudoInverse() {
        return this.pseudoInverse(0.0);
    }

    @Override
    public DiagonalMatrixMTJ pseudoInverse(double effectiveZero) {
        double[] diagonal = this.getDiagonal();
        int M = diagonal.length;
        double[] retval = new double[M];
        for (int i = 0; i < M; ++i) {
            double di = diagonal[i];
            retval[i] = Math.abs(di) <= effectiveZero ? 0.0 : 1.0 / di;
        }
        return new DiagonalMatrixMTJ(retval);
    }

    @Override
    public Matrix inverse() {
        if (!this.isSquare()) {
            throw new UnsupportedOperationException("Can only invert square matrices.");
        }
        return this.pseudoInverse();
    }

    @Override
    public Vector getColumn(int columnIndex) {
        int M = this.getDimensionality();
        Object column = SparseVectorFactoryMTJ.getDefault().createVector(M);
        column.setElement(columnIndex, this.getElement(columnIndex, columnIndex));
        return column;
    }

    @Override
    public Vector getRow(int rowIndex) {
        int N = this.getDimensionality();
        Object row = SparseVectorFactoryMTJ.getDefault().createVector(N);
        row.setElement(rowIndex, this.getElement(rowIndex, rowIndex));
        return row;
    }

    @Override
    public double getElement(int rowIndex, int columnIndex) {
        if (rowIndex != columnIndex) {
            return 0.0;
        }
        return this.getElement(rowIndex);
    }

    @Override
    public void setElement(int rowIndex, int columnIndex, double value) {
        if (rowIndex != columnIndex) {
            if (value != 0.0) {
                throw new IllegalArgumentException("Can only set diagonal elements in a DiagonalMatrix!");
            }
        } else {
            this.setElement(rowIndex, value);
        }
    }

    @Override
    public double getElement(int index) {
        double[] diagonal = this.getDiagonal();
        return diagonal[index];
    }

    @Override
    public void setElement(int index, double value) {
        double[] diagonal = this.getDiagonal();
        diagonal[index] = value;
    }

    @Override
    public DenseVector convertToVector() {
        return DenseVectorFactoryMTJ.INSTANCE.copyArray(this.getDiagonal());
    }

    @Override
    public void convertFromVector(Vector parameters) {
        if (this.getNumRows() != parameters.getDimensionality()) {
            throw new IllegalArgumentException("Wrong number of parameters!");
        }
        double[] diagonal = this.getDiagonal();
        for (int i = 0; i < diagonal.length; ++i) {
            diagonal[i] = parameters.getElement(i);
        }
    }

    @Override
    public String toString() {
        int M = this.getDimensionality();
        StringBuilder retval = new StringBuilder(M * 10);
        retval.append("(" + M + "x" + M + "), diagonal:");
        for (int i = 0; i < M; ++i) {
            retval.append(" " + this.getElement(i));
        }
        return retval.toString();
    }

    @Override
    public String toString(NumberFormat format) {
        int d = this.getDimensionality();
        StringBuilder result = new StringBuilder(d * 5);
        result.append("(" + d + "x" + d + "), diagonal:");
        for (int i = 0; i < d; ++i) {
            result.append(" " + format.format(this.getElement(i)));
        }
        return result.toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        int numDiagonal = this.getDimensionality();
        double[] diag = new double[numDiagonal];
        for (int i = 0; i < numDiagonal; ++i) {
            diag[i] = this.getElement(i);
        }
        out.writeObject(diag);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        double[] diag = (double[])in.readObject();
        this.setInternalMatrix((no.uib.cipr.matrix.Matrix)new BandMatrix(diag.length, 0, 0));
        for (int i = 0; i < diag.length; ++i) {
            this.getDiagonal()[i] = diag[i];
        }
    }
}

