/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.time;

import gov.sandia.cognition.time.Duration;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import java.text.DecimalFormat;

public class DefaultDuration
extends AbstractCloneableSerializable
implements Duration {
    public static final int MILLISECONDS_PER_SECOND = 1000;
    public static final int SECONDS_PER_MINUTE = 60;
    public static final int MINUTES_PER_HOUR = 60;
    public static final int HOURS_PER_DAY = 24;
    public static final int MILLISECONDS_PER_MINUTE = 60000;
    public static final int MILLISECONDS_PER_HOUR = 3600000;
    public static final int MILLISECONDS_PER_DAY = 86400000;
    public static final DefaultDuration ZERO = new DefaultDuration(0.0);
    public static final DefaultDuration MILLISECOND = new DefaultDuration(1.0);
    public static final DefaultDuration SECOND = new DefaultDuration(1000.0);
    public static final DefaultDuration MINUTE = new DefaultDuration(60000.0);
    public static final DefaultDuration HOUR = new DefaultDuration(3600000.0);
    public static final DefaultDuration DAY = new DefaultDuration(8.64E7);
    public static final DefaultDuration MIN_VALUE = new DefaultDuration(-9.223372036854776E18);
    public static final DefaultDuration MAX_VALUE = new DefaultDuration(9.223372036854776E18);
    private static final DecimalFormat TWO_DIGIT_FORMAT = new DecimalFormat("00");
    public static final DecimalFormat THREE_DIGIT_FORMAT = new DecimalFormat("000");
    private double milliseconds;

    protected DefaultDuration(double milliseconds) {
        this.milliseconds = milliseconds;
    }

    public static DefaultDuration fromMilliseconds(double milliseconds) {
        return new DefaultDuration(milliseconds);
    }

    public static DefaultDuration fromSeconds(double seconds) {
        return new DefaultDuration(seconds * 1000.0);
    }

    public static DefaultDuration fromMinutes(double minutes) {
        return new DefaultDuration(minutes * 60000.0);
    }

    public static DefaultDuration fromHours(double hours) {
        return new DefaultDuration(hours * 3600000.0);
    }

    public static DefaultDuration fromDays(double days) {
        return new DefaultDuration(days * 8.64E7);
    }

    public boolean equals(Object other) {
        return other instanceof Duration && this.equals((Duration)other);
    }

    @Override
    public boolean equals(Duration other) {
        return other != null && this.milliseconds == other.getTotalMilliseconds();
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.milliseconds);
        return (int)(bits ^ bits >>> 32);
    }

    @Override
    public int compareTo(Duration other) {
        return Double.compare(this.milliseconds, other.getTotalMilliseconds());
    }

    @Override
    public Duration negative() {
        return new DefaultDuration(-this.milliseconds);
    }

    @Override
    public Duration absoluteValue() {
        return new DefaultDuration(Math.abs(this.milliseconds));
    }

    @Override
    public Duration plus(Duration other) {
        return new DefaultDuration(this.milliseconds + other.getTotalMilliseconds());
    }

    @Override
    public Duration minus(Duration other) {
        return new DefaultDuration(this.milliseconds - other.getTotalMilliseconds());
    }

    @Override
    public Duration times(double scalar) {
        return new DefaultDuration(this.milliseconds * scalar);
    }

    @Override
    public double divide(Duration other) {
        return this.milliseconds / other.getTotalMilliseconds();
    }

    @Override
    public Duration divide(double scalar) {
        return new DefaultDuration(this.milliseconds / scalar);
    }

    @Override
    public double getTotalMilliseconds() {
        return this.milliseconds;
    }

    @Override
    public double getTotalSeconds() {
        return this.milliseconds / 1000.0;
    }

    @Override
    public double getTotalMinutes() {
        return this.milliseconds / 60000.0;
    }

    @Override
    public double getTotalHours() {
        return this.milliseconds / 3600000.0;
    }

    @Override
    public double getTotalDays() {
        return this.milliseconds / 8.64E7;
    }

    @Override
    public int getMillisecondsPart() {
        return (int)(this.milliseconds % 1000.0);
    }

    @Override
    public int getSecondsPart() {
        return (int)(this.milliseconds / 1000.0 % 60.0);
    }

    @Override
    public int getMinutesPart() {
        return (int)(this.milliseconds / 60000.0 % 60.0);
    }

    @Override
    public int getHoursPart() {
        return (int)(this.milliseconds / 3600000.0 % 24.0);
    }

    @Override
    public long getDaysPart() {
        return (long)(this.milliseconds / 8.64E7);
    }

    public String toString() {
        long daysPart;
        StringBuilder result = new StringBuilder();
        if (this.milliseconds < 0.0) {
            result.append("-");
        }
        if ((daysPart = this.getDaysPart()) != 0L) {
            result.append(Math.abs(daysPart));
            result.append(".");
        }
        result.append(TWO_DIGIT_FORMAT.format(Math.abs(this.getHoursPart())));
        result.append(":");
        result.append(TWO_DIGIT_FORMAT.format(Math.abs(this.getMinutesPart())));
        result.append(":");
        result.append(TWO_DIGIT_FORMAT.format(Math.abs(this.getSecondsPart())));
        int millisecondsPart = this.getMillisecondsPart();
        if (millisecondsPart != 0) {
            result.append(".");
            result.append(THREE_DIGIT_FORMAT.format(Math.abs(millisecondsPart)));
        }
        return result.toString();
    }
}

