/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.annealing;

import gov.sandia.cognition.algorithm.MeasurablePerformanceAlgorithm;
import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.annotation.CodeReviews;
import gov.sandia.cognition.learning.algorithm.AbstractAnytimeBatchLearner;
import gov.sandia.cognition.learning.algorithm.BatchCostMinimizationLearner;
import gov.sandia.cognition.learning.algorithm.annealing.Perturber;
import gov.sandia.cognition.learning.function.cost.CostFunction;
import gov.sandia.cognition.util.DefaultNamedValue;
import gov.sandia.cognition.util.NamedValue;
import gov.sandia.cognition.util.ObjectUtil;
import java.io.Serializable;
import java.util.Random;

@CodeReviews(reviews={@CodeReview(reviewer={"Kevin R. Dixon"}, date="2008-07-22", changesNeeded=false, comments={"Moved previous code review to annotation.", "Added HTML tags to javadoc.", "Fixed a few typos in javadoc.", "Code looks fine."}), @CodeReview(reviewer={"Justin Basilico"}, date="2006-10-02", changesNeeded=false, comments={"Did some reformatting of the code.", "Added missing documentation.", "Cleaned up the use of default parameter values."})})
public class SimulatedAnnealer<CostParametersType, AnnealedType>
extends AbstractAnytimeBatchLearner<CostParametersType, AnnealedType>
implements BatchCostMinimizationLearner<CostParametersType, AnnealedType>,
MeasurablePerformanceAlgorithm {
    public static final double DEFAULT_STARTING_TEMPERATURE = 1.0;
    public static final double DEFAULT_COOLING_FACTOR = 0.1;
    public static final int DEFAULT_MAX_ITERATIONS = 1000;
    private CostFunction<? super AnnealedType, ? super CostParametersType> cost;
    private Perturber<AnnealedType> perturber;
    private double temperature;
    private int maxIterationsWithoutImprovement;
    private int iterationsWithoutImprovement;
    private double coolingFactor;
    private Random random;
    private AnnealedType bestSoFar;
    private double bestSoFarScore;
    private AnnealedType current;
    private double currentScore;

    public SimulatedAnnealer(AnnealedType initial, Perturber<AnnealedType> perturber, CostFunction<? super AnnealedType, ? super CostParametersType> cost) {
        this((AnnealedType)initial, (Perturber<? super AnnealedType>)perturber, cost, 1000);
    }

    public SimulatedAnnealer(AnnealedType initial, Perturber<AnnealedType> perturber, CostFunction<? super AnnealedType, ? super CostParametersType> cost, int maxIterations) {
        this((AnnealedType)initial, (Perturber<? super AnnealedType>)perturber, cost, maxIterations, 1 + maxIterations / 10);
    }

    public SimulatedAnnealer(AnnealedType initial, Perturber<AnnealedType> perturber, CostFunction<? super AnnealedType, ? super CostParametersType> cost, int maxIterations, int maxIterationsWithoutImprovement) {
        super(maxIterations);
        this.setCostFunction(cost);
        this.setPerturber(perturber);
        this.setTemperature(1.0);
        this.setMaxIterationsWithoutImprovement(maxIterationsWithoutImprovement);
        this.setIterationsWithoutImprovement(0);
        this.setCoolingFactor(0.1);
        this.setRandom(new Random());
        this.setBestSoFar(null);
        this.setBestSoFarScore(0.0);
        this.setCurrent(initial);
        this.setCurrentScore(0.0);
    }

    @Override
    public SimulatedAnnealer<CostParametersType, AnnealedType> clone() {
        SimulatedAnnealer result = (SimulatedAnnealer)super.clone();
        result.cost = (CostFunction)ObjectUtil.cloneSafe(this.cost);
        result.perturber = (Perturber)ObjectUtil.cloneSafe(this.perturber);
        result.random = (Random)ObjectUtil.deepCopy((Serializable)this.random);
        result.bestSoFar = null;
        result.bestSoFarScore = 0.0;
        result.current = null;
        result.currentScore = 0.0;
        return result;
    }

    @Override
    protected boolean initializeAlgorithm() {
        this.setIteration(0);
        this.setIterationsWithoutImprovement(0);
        this.setCurrentScore(this.getCostFunction().evaluate(this.getCurrent()));
        this.setBestSoFar(this.getCurrent());
        this.setBestSoFarScore(this.getCurrentScore());
        return true;
    }

    @Override
    protected boolean step() {
        AnnealedType next = this.getPerturber().perturb(this.getCurrent());
        double nextScore = this.getCostFunction().evaluate(next);
        if (nextScore < this.getBestSoFarScore()) {
            this.setBestSoFar(next);
            this.setBestSoFarScore(nextScore);
            this.setIterationsWithoutImprovement(0);
        } else {
            this.setIterationsWithoutImprovement(this.getIterationsWithoutImprovement() + 1);
        }
        double scoreDiff = nextScore - this.currentScore;
        if (scoreDiff <= 0.0 || this.getRandom().nextDouble() < Math.exp(-scoreDiff / this.getTemperature())) {
            this.setCurrent(next);
            this.setCurrentScore(nextScore);
        }
        this.setTemperature(this.getCoolingFactor() * this.getTemperature());
        return this.getIterationsWithoutImprovement() <= this.getMaxIterationsWithoutImprovement();
    }

    @Override
    public CostFunction<? super AnnealedType, ? super CostParametersType> getCostFunction() {
        return this.cost;
    }

    public Perturber<AnnealedType> getPerturber() {
        return this.perturber;
    }

    protected double getTemperature() {
        return this.temperature;
    }

    public int getMaxIterationsWithoutImprovement() {
        return this.maxIterationsWithoutImprovement;
    }

    protected int getIterationsWithoutImprovement() {
        return this.iterationsWithoutImprovement;
    }

    public double getCoolingFactor() {
        return this.coolingFactor;
    }

    public Random getRandom() {
        return this.random;
    }

    protected AnnealedType getBestSoFar() {
        return this.bestSoFar;
    }

    protected double getBestSoFarScore() {
        return this.bestSoFarScore;
    }

    protected AnnealedType getCurrent() {
        return this.current;
    }

    protected double getCurrentScore() {
        return this.currentScore;
    }

    public void setCostFunction(CostFunction<? super AnnealedType, ? super CostParametersType> cost) {
        this.cost = cost;
    }

    public void setPerturber(Perturber<AnnealedType> perturber) {
        this.perturber = perturber;
    }

    protected void setTemperature(double temperature) {
        this.temperature = temperature;
    }

    public void setMaxIterationsWithoutImprovement(int maxIterationsWithoutImprovement) {
        this.maxIterationsWithoutImprovement = maxIterationsWithoutImprovement;
    }

    protected void setIterationsWithoutImprovement(int iterationsWithoutImprovement) {
        this.iterationsWithoutImprovement = iterationsWithoutImprovement;
    }

    public void setCoolingFactor(double coolingFactor) {
        if (coolingFactor <= 0.0 || coolingFactor > 1.0) {
            throw new IllegalArgumentException("The cooling factor must begreater than zero and less than or equal to one.");
        }
        this.coolingFactor = coolingFactor;
    }

    public void setRandom(Random random) {
        this.random = random;
    }

    protected void setBestSoFar(AnnealedType bestSoFar) {
        this.bestSoFar = bestSoFar;
    }

    protected void setBestSoFarScore(double bestSoFarScore) {
        this.bestSoFarScore = bestSoFarScore;
    }

    protected void setCurrent(AnnealedType current) {
        this.current = current;
    }

    protected void setCurrentScore(double currentScore) {
        this.currentScore = currentScore;
    }

    @Override
    protected void cleanupAlgorithm() {
    }

    public AnnealedType getResult() {
        return this.getBestSoFar();
    }

    public NamedValue<Double> getPerformance() {
        return new DefaultNamedValue("score", (Object)this.getBestSoFarScore());
    }
}

