/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.baseline;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.learning.algorithm.SupervisedBatchLearner;
import gov.sandia.cognition.learning.data.DatasetUtil;
import gov.sandia.cognition.learning.data.InputOutputPair;
import gov.sandia.cognition.learning.function.ConstantEvaluator;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import java.util.Collection;

@CodeReview(reviewer={"Kevin R. Dixon"}, date="2008-07-22", changesNeeded=false, comments={"Fixed a few typos in javadoc.", "Removed implements Serializeable, as BatchLearner already does that.", "I don't particularly like this class... I just don't think it's useful.", "However, the code looks fine."})
public class MeanLearner
extends AbstractCloneableSerializable
implements SupervisedBatchLearner<Object, Double, ConstantEvaluator<Double>> {
    @Override
    public ConstantEvaluator<Double> learn(Collection<? extends InputOutputPair<?, Double>> data) {
        double mean = DatasetUtil.computeOutputMean(data);
        return new ConstantEvaluator<Double>(mean);
    }
}

