/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.clustering;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.learning.algorithm.clustering.KMeansClusterer;
import gov.sandia.cognition.learning.algorithm.clustering.cluster.CentroidCluster;
import gov.sandia.cognition.learning.algorithm.clustering.cluster.ClusterCreator;
import gov.sandia.cognition.learning.algorithm.clustering.divergence.CentroidClusterDivergenceFunction;
import gov.sandia.cognition.learning.algorithm.clustering.initializer.FixedClusterInitializer;
import gov.sandia.cognition.math.Metric;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

@CodeReview(reviewer={"Kevin R. Dixon"}, date="2008-07-22", changesNeeded=false, comments={"Added PublicationReference", "Code generally looks fine."})
@PublicationReference(author={"C. Elkan"}, title="Using the Triangle Inequality to Accelerate k-Means", type=PublicationType.Conference, year=2003, publication="Proceedings of the Twentieth International Conference on Machine Learning", pages={147, 153}, url="www-cse.ucsd.edu/~elkan/kmeansicml03.pdf")
public class OptimizedKMeansClusterer<DataType>
extends KMeansClusterer<DataType, CentroidCluster<DataType>> {
    private Metric<? super DataType> metric;
    protected double[][] lowerBounds;
    protected double[] upperBounds;
    protected double[][] clusterDistances;

    public OptimizedKMeansClusterer(int numClusters, int maxIterations, FixedClusterInitializer<CentroidCluster<DataType>, DataType> initializer, Metric<? super DataType> metric, ClusterCreator<CentroidCluster<DataType>, DataType> creator) {
        super(numClusters, maxIterations, initializer, new CentroidClusterDivergenceFunction(metric), creator);
        this.setMetric(metric);
        this.setLowerBounds(null);
        this.setUpperBounds(null);
        this.setClusterDistances(null);
    }

    @Override
    public OptimizedKMeansClusterer<DataType> clone() {
        OptimizedKMeansClusterer result = (OptimizedKMeansClusterer)super.clone();
        result.metric = (Metric)result.divergenceFunction;
        result.lowerBounds = null;
        result.upperBounds = null;
        result.clusterDistances = null;
        return result;
    }

    @Override
    protected boolean initializeAlgorithm() {
        boolean superReturn = super.initializeAlgorithm();
        int N = this.getNumElements();
        int k = this.getNumClusters();
        this.setLowerBounds(new double[N][k]);
        this.setUpperBounds(new double[N]);
        this.setClusterDistances(new double[k][k]);
        return superReturn;
    }

    protected void computeClusterDistances() {
        for (int i = 0; i < this.getNumClusters(); ++i) {
            DataType clusterI = this.getClusterCentroid(i);
            this.clusterDistances[i][i] = this.metric.evaluate(clusterI, clusterI);
            for (int j = i + 1; j < this.getNumClusters(); ++j) {
                double distance;
                DataType clusterJ = this.getClusterCentroid(j);
                this.clusterDistances[i][j] = distance = this.metric.evaluate(clusterI, clusterJ);
                this.clusterDistances[j][i] = distance;
            }
        }
    }

    @Override
    protected boolean step() {
        int j;
        this.setNumChanged(0);
        if (this.getNumClusters() <= 0) {
            return false;
        }
        this.computeClusterDistances();
        double[] s = new double[this.getNumClusters()];
        for (int i = 0; i < this.getNumClusters(); ++i) {
            double minDistance = Double.MAX_VALUE;
            for (j = 0; j < this.getNumClusters(); ++j) {
                double distance = this.clusterDistances[i][j];
                if (i == j || !(distance < minDistance)) continue;
                minDistance = distance;
            }
            s[i] = 0.5 * minDistance;
        }
        Iterator iterator = ((Collection)this.data).iterator();
        for (int i = 0; i < this.getNumElements(); ++i) {
            Object element = iterator.next();
            int assignment = this.assignments[i];
            if (assignment < 0) {
                double minDistance = Double.MAX_VALUE;
                for (int j2 = 0; j2 < this.getNumClusters(); ++j2) {
                    double distance;
                    this.lowerBounds[i][j2] = distance = this.metric.evaluate(element, this.getClusterCentroid(j2));
                    if (assignment >= 0 && !(distance < minDistance)) continue;
                    assignment = j2;
                    minDistance = distance;
                }
                this.setAssignment(i, assignment);
                this.upperBounds[i] = minDistance;
                this.setNumChanged(this.getNumChanged() + 1);
                continue;
            }
            if (this.upperBounds[i] <= s[assignment]) continue;
            int oldAssignment = assignment;
            double distanceToCluster = 0.0;
            boolean distanceToClusterComputed = false;
            for (int j3 = 0; j3 < this.getNumClusters(); ++j3) {
                double distance;
                if (j3 == this.assignments[i] || this.upperBounds[i] <= this.lowerBounds[i][j3] || this.upperBounds[i] <= 0.5 * this.clusterDistances[assignment][j3]) continue;
                if (!distanceToClusterComputed) {
                    this.lowerBounds[i][assignment] = distanceToCluster = this.metric.evaluate(element, this.getClusterCentroid(assignment));
                    distanceToClusterComputed = true;
                }
                if (!(distanceToCluster > this.lowerBounds[i][j3]) && !(distanceToCluster > 0.5 * this.clusterDistances[assignment][j3])) continue;
                this.lowerBounds[i][j3] = distance = this.metric.evaluate(element, this.getClusterCentroid(j3));
                if (!(distance < distanceToCluster)) continue;
                distanceToCluster = distance;
                assignment = j3;
                this.setAssignment(i, j3);
                this.upperBounds[i] = distance;
            }
            if (oldAssignment == assignment) continue;
            this.setNumChanged(this.getNumChanged() + 1);
        }
        ArrayList<DataType> oldCentroids = new ArrayList<DataType>(this.getNumClusters());
        for (int i = 0; i < this.getNumClusters(); ++i) {
            oldCentroids.add(this.getClusterCentroid(i));
        }
        this.createClustersFromAssignments();
        double[] clusterDeltas = new double[this.getNumClusters()];
        for (j = 0; j < this.getNumClusters(); ++j) {
            double meanChange;
            Object oldCentroid = oldCentroids.get(j);
            DataType newCentroid = this.getClusterCentroid(j);
            clusterDeltas[j] = meanChange = this.metric.evaluate(oldCentroid, newCentroid);
            for (int i = 0; i < this.getNumElements(); ++i) {
                this.lowerBounds[i][j] = Math.max(0.0, this.lowerBounds[i][j] - meanChange);
            }
        }
        for (int i = 0; i < this.getNumElements(); ++i) {
            int n = i;
            this.upperBounds[n] = this.upperBounds[n] + clusterDeltas[this.assignments[i]];
        }
        return this.getNumChanged() > 0;
    }

    public DataType getClusterCentroid(int clusterIndex) {
        CentroidCluster cluster = (CentroidCluster)this.clusters.get(clusterIndex);
        if (cluster == null) {
            return null;
        }
        return (DataType)cluster.getCentroid();
    }

    public Metric<? super DataType> getMetric() {
        return this.metric;
    }

    private void setMetric(Metric<? super DataType> metric) {
        if (metric == null) {
            throw new NullPointerException("The metric cannot be null.");
        }
        this.metric = metric;
    }

    private void setLowerBounds(double[][] lowerBounds) {
        this.lowerBounds = lowerBounds;
    }

    private void setUpperBounds(double[] upperBounds) {
        this.upperBounds = upperBounds;
    }

    private void setClusterDistances(double[][] clusterDistances) {
        this.clusterDistances = clusterDistances;
    }
}

