/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.clustering;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.collection.CollectionUtil;
import gov.sandia.cognition.learning.algorithm.AbstractAnytimeBatchLearner;
import gov.sandia.cognition.learning.algorithm.clustering.BatchClusterer;
import gov.sandia.cognition.learning.algorithm.clustering.cluster.Cluster;
import gov.sandia.cognition.learning.algorithm.clustering.cluster.IncrementalClusterCreator;
import gov.sandia.cognition.learning.algorithm.clustering.divergence.ClusterDivergenceFunction;
import gov.sandia.cognition.learning.algorithm.clustering.hierarchy.BatchHierarchicalClusterer;
import gov.sandia.cognition.learning.algorithm.clustering.hierarchy.BinaryClusterHierarchyNode;
import gov.sandia.cognition.learning.algorithm.clustering.hierarchy.ClusterHierarchyNode;
import gov.sandia.cognition.util.ArgumentChecker;
import gov.sandia.cognition.util.DefaultPair;
import gov.sandia.cognition.util.ObjectUtil;
import gov.sandia.cognition.util.Randomized;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;

@CodeReview(reviewer={"Justin Basilico"}, date="2011-03-09", comments={"Should make do a greedy splitting prioritization.", "Should make an interface for incremental cluster creation for this to use."}, changesNeeded=true)
@PublicationReference(author={"Ying Zhao", "George Karypis"}, title="Hierarchical Clustering Algorithms for Document Datasets", type=PublicationType.Journal, year=2005, publication="Data Mining and Knowledge Discovery", pages={141, 168}, url="http://www.springerlink.com/index/jx3825j42x4333m5.pdf")
public class PartitionalClusterer<DataType, ClusterType extends Cluster<DataType>>
extends AbstractAnytimeBatchLearner<Collection<? extends DataType>, Collection<ClusterType>>
implements BatchClusterer<DataType, ClusterType>,
BatchHierarchicalClusterer<DataType, ClusterType>,
Randomized {
    public static final int DEFAULT_MIN_CLUSTER_SIZE = 1;
    public static final double DEFAULT_MAX_CRITERION_DECREASE = 1.0;
    public static final int DEFAULT_MAX_ITERATIONS = Integer.MAX_VALUE;
    protected ClusterDivergenceFunction<ClusterType, DataType> divergenceFunction;
    protected IncrementalClusterCreator<ClusterType, DataType> creator;
    protected int minClusterSize;
    protected double maxCriterionDecrease;
    protected Random random;
    protected transient ArrayList<ClusterType> clusters;
    protected transient ArrayList<BinaryClusterHierarchyNode<DataType, ClusterType>> clustersHierarchy;

    public PartitionalClusterer() {
        this(null, null, new Random());
    }

    public PartitionalClusterer(ClusterDivergenceFunction<ClusterType, DataType> divergenceFunction, IncrementalClusterCreator<ClusterType, DataType> creator, Random random) {
        this(divergenceFunction, creator, 1, 1.0, random);
    }

    public PartitionalClusterer(ClusterDivergenceFunction<ClusterType, DataType> divergenceFunction, IncrementalClusterCreator<ClusterType, DataType> creator, int minClusterSize, double maxCriterionDecrease, Random random) {
        this(divergenceFunction, creator, Integer.MAX_VALUE, minClusterSize, maxCriterionDecrease, random);
    }

    public PartitionalClusterer(ClusterDivergenceFunction<ClusterType, DataType> divergenceFunction, IncrementalClusterCreator<ClusterType, DataType> creator, int maxIterations, int minClusterSize, double maxCriterionDecrease, Random random) {
        super(maxIterations);
        this.setDivergenceFunction(divergenceFunction);
        this.setCreator(creator);
        this.setMinClusterSize(minClusterSize);
        this.setMaxCriterionDecrease(maxCriterionDecrease);
        this.setClusters(null);
        this.setClustersHierarchy(null);
        this.setRandom(random);
    }

    @Override
    public PartitionalClusterer<DataType, ClusterType> clone() {
        PartitionalClusterer result = (PartitionalClusterer)super.clone();
        result.divergenceFunction = (ClusterDivergenceFunction)ObjectUtil.cloneSafe(this.divergenceFunction);
        result.creator = (IncrementalClusterCreator)ObjectUtil.cloneSafe(this.creator);
        result.clusters = null;
        result.clustersHierarchy = null;
        return result;
    }

    @Override
    public ClusterHierarchyNode<DataType, ClusterType> clusterHierarchically(Collection<? extends DataType> data) {
        this.learn(data);
        if (CollectionUtil.isEmpty(this.clustersHierarchy)) {
            return null;
        }
        return this.clustersHierarchy.get(0);
    }

    @Override
    protected boolean initializeAlgorithm() {
        this.setClusters(new ArrayList());
        this.setClustersHierarchy(new ArrayList<BinaryClusterHierarchyNode<DataType, ClusterType>>());
        ArrayList dataList = new ArrayList((Collection)this.data);
        Object cluster = this.creator.createCluster(dataList);
        this.clusters.add(cluster);
        this.clustersHierarchy.add(new BinaryClusterHierarchyNode(cluster));
        return true;
    }

    @Override
    protected boolean step() {
        int clusterIndex = this.iteration - 1;
        if (clusterIndex >= this.getClusterCount()) {
            return false;
        }
        Cluster clusterToSplit = (Cluster)this.clusters.get(clusterIndex);
        if (clusterToSplit.getMembers().size() <= this.getMinClusterSize()) {
            return true;
        }
        BinaryClusterHierarchyNode clusterToSplitNode = this.clustersHierarchy.get(clusterIndex);
        DefaultPair<Cluster, Cluster> clusterChildren = this.randomPartition(clusterToSplit);
        Cluster leftCluster = (Cluster)clusterChildren.getFirst();
        Cluster rightCluster = (Cluster)clusterChildren.getSecond();
        this.greedySwap(clusterToSplit.getMembers(), leftCluster, rightCluster);
        if (leftCluster.getMembers().size() >= this.minClusterSize && rightCluster.getMembers().size() >= this.minClusterSize) {
            double rightCriteria;
            double leftCriteria;
            boolean improved;
            double clusterCriteria = this.evaluateCriterion(clusterToSplit);
            boolean bl = improved = clusterCriteria * this.maxCriterionDecrease > (leftCriteria = this.evaluateCriterion(leftCluster)) + (rightCriteria = this.evaluateCriterion(rightCluster));
            if (improved) {
                this.clusters.add(leftCluster);
                this.clusters.add(rightCluster);
                BinaryClusterHierarchyNode leftNode = new BinaryClusterHierarchyNode(leftCluster);
                BinaryClusterHierarchyNode rightNode = new BinaryClusterHierarchyNode(rightCluster);
                this.clustersHierarchy.add(leftNode);
                this.clustersHierarchy.add(rightNode);
                clusterToSplitNode.setFirstChild(leftNode);
                clusterToSplitNode.setSecondChild(rightNode);
            }
        }
        return true;
    }

    @Override
    protected void cleanupAlgorithm() {
    }

    public ArrayList<ClusterType> getResult() {
        return this.clusters;
    }

    private DefaultPair<ClusterType, ClusterType> randomPartition(ClusterType clusterToSplit) {
        ArrayList<Object> leftMembers = new ArrayList<Object>();
        ArrayList<Object> rightMembers = new ArrayList<Object>();
        for (Object member : clusterToSplit.getMembers()) {
            if (this.random.nextBoolean()) {
                leftMembers.add(member);
                continue;
            }
            rightMembers.add(member);
        }
        if (leftMembers.isEmpty()) {
            int rightSize = rightMembers.size();
            int randomIndex = this.random.nextInt(rightSize);
            leftMembers.add(rightMembers.remove(randomIndex));
        }
        if (rightMembers.isEmpty()) {
            int leftSize = leftMembers.size();
            int randomIndex = this.random.nextInt(leftSize);
            rightMembers.add(leftMembers.remove(randomIndex));
        }
        return DefaultPair.create(this.creator.createCluster(leftMembers), this.creator.createCluster(rightMembers));
    }

    private void greedySwap(Collection<DataType> data, ClusterType leftCluster, ClusterType rightCluster) {
        boolean improved = true;
        double criterion = this.evaluateCriterion(leftCluster) + this.evaluateCriterion(rightCluster);
        while (improved) {
            improved = false;
            for (DataType member : data) {
                this.swapElement(leftCluster, rightCluster, member);
                double testCriterion = this.evaluateCriterion(leftCluster) + this.evaluateCriterion(rightCluster);
                if (testCriterion < criterion) {
                    criterion = testCriterion;
                    improved = true;
                    continue;
                }
                this.swapElement(leftCluster, rightCluster, member);
            }
        }
    }

    private void swapElement(ClusterType leftCluster, ClusterType rightCluster, DataType element) {
        if (leftCluster.getMembers().contains(element) && leftCluster.getMembers().size() > 1) {
            this.creator.removeClusterMember(leftCluster, element);
            this.creator.addClusterMember(rightCluster, element);
        } else if (rightCluster.getMembers().contains(element) && rightCluster.getMembers().size() > 1) {
            this.creator.removeClusterMember(rightCluster, element);
            this.creator.addClusterMember(leftCluster, element);
        }
    }

    private double evaluateCriterion(ClusterType cluster) {
        double total = 0.0;
        for (Object member : cluster.getMembers()) {
            total += this.divergenceFunction.evaluate(cluster, member);
        }
        return total;
    }

    public int getClusterCount() {
        if (this.clusters == null) {
            return 0;
        }
        return this.clusters.size();
    }

    public ClusterDivergenceFunction<ClusterType, DataType> getDivergenceFunction() {
        return this.divergenceFunction;
    }

    public void setDivergenceFunction(ClusterDivergenceFunction<ClusterType, DataType> divergenceFunction) {
        this.divergenceFunction = divergenceFunction;
    }

    public IncrementalClusterCreator<ClusterType, DataType> getCreator() {
        return this.creator;
    }

    public void setCreator(IncrementalClusterCreator<ClusterType, DataType> creator) {
        this.creator = creator;
    }

    public Random getRandom() {
        return this.random;
    }

    public void setRandom(Random random) {
        this.random = random;
    }

    public int getMinClusterSize() {
        return this.minClusterSize;
    }

    public void setMinClusterSize(int minClusterSize) {
        ArgumentChecker.assertIsPositive((String)"minClusterSize", (int)minClusterSize);
        this.minClusterSize = minClusterSize;
    }

    public double getMaxCriterionDecrease() {
        return this.maxCriterionDecrease;
    }

    public void setMaxCriterionDecrease(double maxCriterionDecrease) {
        ArgumentChecker.assertIsPositive((String)"maxCriterionDecrease", (double)maxCriterionDecrease);
        this.maxCriterionDecrease = maxCriterionDecrease;
    }

    protected void setClusters(ArrayList<ClusterType> clusters) {
        this.clusters = clusters;
    }

    public ArrayList<BinaryClusterHierarchyNode<DataType, ClusterType>> getClustersHierarchy() {
        return this.clustersHierarchy;
    }

    protected void setClustersHierarchy(ArrayList<BinaryClusterHierarchyNode<DataType, ClusterType>> clustersHierarchy) {
        this.clustersHierarchy = clustersHierarchy;
    }
}

