/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.clustering.divergence;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.learning.algorithm.clustering.cluster.Cluster;
import gov.sandia.cognition.learning.algorithm.clustering.divergence.AbstractClusterToClusterDivergenceFunction;
import gov.sandia.cognition.math.DivergenceFunction;
import java.util.Collection;

@CodeReview(reviewer={"Kevin R. Dixon"}, date="2008-07-23", changesNeeded=false, comments={"Cleaned up javadoc a little bit with code annotations.", "Otherwise, looks fine."})
public class ClusterSingleLinkDivergenceFunction<ClusterType extends Cluster<DataType>, DataType>
extends AbstractClusterToClusterDivergenceFunction<ClusterType, DataType> {
    public ClusterSingleLinkDivergenceFunction() {
        this((DivergenceFunction<DataType, DataType>)null);
    }

    public ClusterSingleLinkDivergenceFunction(DivergenceFunction<? super DataType, ? super DataType> divergenceFunction) {
        super(divergenceFunction);
    }

    public double evaluate(ClusterType from, ClusterType to) {
        Collection fromMembers = from.getMembers();
        Collection toMembers = to.getMembers();
        double minDistance = Double.MAX_VALUE;
        for (Object first : fromMembers) {
            for (Object second : toMembers) {
                double distance = this.divergenceFunction.evaluate(first, second);
                if (!(distance < minDistance)) continue;
                minDistance = distance;
            }
        }
        return minDistance;
    }
}

