/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.genetic.reproducer;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.annotation.CodeReviews;
import gov.sandia.cognition.learning.algorithm.genetic.EvaluatedGenome;
import gov.sandia.cognition.learning.algorithm.genetic.reproducer.Reproducer;
import java.util.ArrayList;
import java.util.Collection;

@CodeReviews(reviews={@CodeReview(reviewer={"Kevin R. Dixon"}, date="2008-07-23", changesNeeded=false, comments={"This class still has an open task... I suspect this is due to a lack of interest.", "Moved previous code review as CodeReview annotation.", "Looks fine."}), @CodeReview(reviewer={"Justin Basilico"}, date="2006-10-04", changesNeeded=false, comments={"Minor changes made.", "Looks fine otherwise."})})
public class MultiReproducer<GenomeType>
implements Reproducer<GenomeType> {
    private Collection<Reproducer<GenomeType>> reproducers;

    public MultiReproducer(Collection<Reproducer<GenomeType>> reproducers) {
        this.setReproducers(reproducers);
    }

    @Override
    public ArrayList<GenomeType> reproduce(Collection<EvaluatedGenome<GenomeType>> genomes) {
        ArrayList<GenomeType> newGenomes = new ArrayList<GenomeType>(genomes.size());
        for (Reproducer<GenomeType> reproducer : this.getReproducers()) {
            newGenomes.addAll(reproducer.reproduce(genomes));
        }
        return newGenomes;
    }

    public Collection<Reproducer<GenomeType>> getReproducers() {
        return this.reproducers;
    }

    public void setReproducers(Collection<Reproducer<GenomeType>> reproducers) {
        this.reproducers = reproducers;
    }
}

