/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.genetic.reproducer;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.annotation.CodeReviews;
import gov.sandia.cognition.learning.algorithm.genetic.reproducer.CrossoverFunction;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.Vectorizable;
import gov.sandia.cognition.util.AbstractRandomized;
import java.util.Random;

@CodeReviews(reviews={@CodeReview(reviewer={"Kevin R. Dixon"}, date="2008-07-23", changesNeeded=false, comments={"Now extends AbstractRandomized.", "Moved previous code review as CodeReview annotation", "Looks fine."}), @CodeReview(reviewer={"Justin Basilico"}, date="2006-10-04", changesNeeded=false, comments={"Restructured the code to get rid of some extra copying.", "Added the Random object as part of the constructor instead of creating it each time inside the reproduction loop."})})
public class VectorizableCrossoverFunction
extends AbstractRandomized
implements CrossoverFunction<Vectorizable> {
    private double probabilityCrossover;
    public static final double DEFAULT_PROBABILITY = 0.5;

    public VectorizableCrossoverFunction() {
        this(0.5);
    }

    public VectorizableCrossoverFunction(double probabilityCrossover) {
        this(probabilityCrossover, new Random());
    }

    public VectorizableCrossoverFunction(double probabilityCrossover, Random random) {
        super(random);
        this.setProbabilityCrossover(probabilityCrossover);
    }

    @Override
    public Vectorizable crossover(Vectorizable parent1, Vectorizable parent2) {
        Vector vector1 = parent1.convertToVector();
        Vector vector2 = parent2.convertToVector();
        Vector child = vector1.clone();
        for (int i = 0; i < child.getDimensionality(); ++i) {
            if (!(this.random.nextDouble() <= this.getProbabilityCrossover())) continue;
            child.setElement(i, vector2.getElement(i));
        }
        Vectorizable result = parent1.clone();
        result.convertFromVector(child);
        return result;
    }

    public double getProbabilityCrossover() {
        return this.probabilityCrossover;
    }

    public void setProbabilityCrossover(double probabilityCrossover) {
        this.probabilityCrossover = probabilityCrossover;
    }
}

