/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.minimization;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationReferences;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.learning.algorithm.minimization.FunctionMinimizerConjugateGradient;
import gov.sandia.cognition.learning.algorithm.minimization.line.LineMinimizer;
import gov.sandia.cognition.math.Ring;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.util.CloneableSerializable;
import gov.sandia.cognition.util.ObjectUtil;

@PublicationReferences(references={@PublicationReference(author={"R. Fletcher"}, title="Practical Methods of Optimization, Second Edition", type=PublicationType.Book, year=1987, pages={83}, notes={"Equation 4.1.12"}), @PublicationReference(author={"William H. Press", "Saul A. Teukolsky", "William T. Vetterling", "Brian P. Flannery"}, title="Numerical Recipes in C, Second Edition", type=PublicationType.Book, year=1992, pages={423, 424}, notes={"Section 10.6"}, url="http://www.nrbook.com/a/bookcpdf.php")})
public class FunctionMinimizerPolakRibiere
extends FunctionMinimizerConjugateGradient {
    public FunctionMinimizerPolakRibiere() {
        this((LineMinimizer)ObjectUtil.cloneSafe((CloneableSerializable)DEFAULT_LINE_MINIMIZER));
    }

    public FunctionMinimizerPolakRibiere(LineMinimizer<?> lineMinimizer) {
        this(lineMinimizer, null, 1.0E-5, 1000);
    }

    public FunctionMinimizerPolakRibiere(LineMinimizer<?> lineMinimizer, Vector initialGuess, double tolerance, int maxIterations) {
        super(lineMinimizer, initialGuess, tolerance, maxIterations);
    }

    @Override
    protected double computeScaleFactor(Vector gradientCurrent, Vector gradientPrevious) {
        Vector deltaGradient = (Vector)gradientCurrent.minus((Ring)gradientPrevious);
        double deltaTgradient = deltaGradient.dotProduct(gradientCurrent);
        double denom = gradientPrevious.norm2Squared();
        double beta = deltaTgradient / denom;
        return beta;
    }
}

