/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.minimization.line;

import gov.sandia.cognition.evaluator.Evaluator;
import gov.sandia.cognition.learning.algorithm.minimization.AbstractAnytimeFunctionMinimizer;
import gov.sandia.cognition.learning.algorithm.minimization.line.DirectionalVectorToScalarFunction;
import gov.sandia.cognition.learning.algorithm.minimization.line.LineBracket;
import gov.sandia.cognition.learning.algorithm.minimization.line.LineMinimizer;
import gov.sandia.cognition.learning.algorithm.minimization.line.interpolator.LineBracketInterpolator;
import gov.sandia.cognition.learning.data.DefaultWeightedInputOutputPair;
import gov.sandia.cognition.learning.data.InputOutputPair;
import gov.sandia.cognition.learning.data.WeightedInputOutputPair;
import gov.sandia.cognition.math.matrix.Vector;

public abstract class AbstractAnytimeLineMinimizer<EvaluatorType extends Evaluator<Double, Double>>
extends AbstractAnytimeFunctionMinimizer<Double, Double, EvaluatorType>
implements LineMinimizer<EvaluatorType> {
    public static final int DEFAULT_MAX_ITERATIONS = 100;
    public static final double DEFAULT_TOLERANCE = 1.0E-5;
    private LineBracket bracket;
    private boolean validBracket;
    private LineBracketInterpolator<? super EvaluatorType> interpolator;
    private Double initialGuessFunctionValue;
    private Double initialGuessSlope;

    public AbstractAnytimeLineMinimizer(LineBracketInterpolator<? super EvaluatorType> interpolator) {
        this(interpolator, null, null, 1.0E-5, 100);
    }

    public AbstractAnytimeLineMinimizer(LineBracketInterpolator<? super EvaluatorType> interpolator, LineBracket bracket, Double initialGuess, double tolerance, int maxIterations) {
        super(initialGuess, tolerance, maxIterations);
        this.setInterpolator(interpolator);
        this.setBracket(bracket);
    }

    @Override
    protected boolean initializeAlgorithm() {
        this.setValidBracket(false);
        this.setBracket(new LineBracket());
        this.result = null;
        return this.getInitialGuess() != null && this.getInterpolator() != null;
    }

    @Override
    protected boolean step() {
        boolean retval;
        if (!this.isValidBracket()) {
            this.setValidBracket(this.bracketingStep());
            retval = true;
        } else {
            retval = this.sectioningStep();
        }
        return retval;
    }

    @Override
    protected void cleanupAlgorithm() {
    }

    @Override
    public WeightedInputOutputPair<Vector, Double> minimizeAlongDirection(DirectionalVectorToScalarFunction function, Double functionValue, Vector gradient) {
        double x = 0.0;
        if (functionValue == null) {
            functionValue = function.evaluate(0.0);
        }
        Double slope = gradient == null ? null : Double.valueOf(gradient.dotProduct(function.getDirection()));
        this.setInitialGuess(0.0);
        this.setInitialGuessFunctionValue(functionValue);
        this.setInitialGuessSlope(slope);
        InputOutputPair lineMinimum = (InputOutputPair)this.learn(function);
        double scale = (Double)lineMinimum.getInput();
        Vector vectorInput = function.computeVector(scale);
        return new DefaultWeightedInputOutputPair<Vector, Double>(vectorInput, (Double)lineMinimum.getOutput(), scale);
    }

    @Override
    public abstract boolean bracketingStep();

    @Override
    public abstract boolean sectioningStep();

    @Override
    public boolean isValidBracket() {
        return this.validBracket;
    }

    public void setValidBracket(boolean validBracket) {
        this.validBracket = validBracket;
    }

    @Override
    public LineBracketInterpolator<? super EvaluatorType> getInterpolator() {
        return this.interpolator;
    }

    public void setInterpolator(LineBracketInterpolator<? super EvaluatorType> interpolator) {
        this.interpolator = interpolator;
    }

    @Override
    public LineBracket getBracket() {
        return this.bracket;
    }

    public void setBracket(LineBracket bracket) {
        this.bracket = bracket;
    }

    @Override
    public void setData(EvaluatorType data) {
        super.setData(data);
    }

    @Override
    public void setInitialGuess(Double initialGuess) {
        this.setInitialGuessFunctionValue(null);
        this.setInitialGuessSlope(null);
        super.setInitialGuess(initialGuess);
    }

    public Double getInitialGuessFunctionValue() {
        return this.initialGuessFunctionValue;
    }

    public void setInitialGuessFunctionValue(Double initialGuessFunctionValue) {
        this.initialGuessFunctionValue = initialGuessFunctionValue;
    }

    public Double getInitialGuessSlope() {
        return this.initialGuessSlope;
    }

    public void setInitialGuessSlope(Double initialGuessSlope) {
        this.initialGuessSlope = initialGuessSlope;
    }
}

