/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.minimization.line;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.annotation.CodeReviews;
import gov.sandia.cognition.learning.algorithm.minimization.line.InputOutputSlopeTriplet;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import gov.sandia.cognition.util.CloneableSerializable;
import gov.sandia.cognition.util.ObjectUtil;

@CodeReviews(reviews={@CodeReview(reviewer={"Kevin R. Dixon"}, date="2009-07-06", changesNeeded=false, comments={"Made clone() call super.clone().", "Fixed the brittleness in the copy constructor.", "Looks fine."}), @CodeReview(reviewer={"Justin Basilico"}, date="2006-10-05", changesNeeded=false, comments={"Class looks fine. Compared against the code it is based on from Numerical Recipies in C and it looks fine."})})
public class LineBracket
extends AbstractCloneableSerializable {
    private InputOutputSlopeTriplet lowerBound;
    private InputOutputSlopeTriplet upperBound;
    private InputOutputSlopeTriplet otherPoint;

    public LineBracket() {
        this(null, null, null);
    }

    public LineBracket(InputOutputSlopeTriplet lowerBound, InputOutputSlopeTriplet upperBound, InputOutputSlopeTriplet otherPoint) {
        this.setLowerBound(lowerBound);
        this.setUpperBound(upperBound);
        this.setOtherPoint(otherPoint);
    }

    public LineBracket(LineBracket other) {
        this((InputOutputSlopeTriplet)ObjectUtil.cloneSafe((CloneableSerializable)other.getLowerBound()), (InputOutputSlopeTriplet)ObjectUtil.cloneSafe((CloneableSerializable)other.getUpperBound()), (InputOutputSlopeTriplet)ObjectUtil.cloneSafe((CloneableSerializable)other.getOtherPoint()));
    }

    public LineBracket clone() {
        LineBracket clone = (LineBracket)super.clone();
        clone.setLowerBound((InputOutputSlopeTriplet)ObjectUtil.cloneSafe((CloneableSerializable)this.getLowerBound()));
        clone.setUpperBound((InputOutputSlopeTriplet)ObjectUtil.cloneSafe((CloneableSerializable)this.getUpperBound()));
        clone.setOtherPoint((InputOutputSlopeTriplet)ObjectUtil.cloneSafe((CloneableSerializable)this.getOtherPoint()));
        return clone;
    }

    public String toString() {
        return "Lower: " + this.getLowerBound() + " Upper: " + this.getUpperBound() + " Other: " + this.getOtherPoint();
    }

    public InputOutputSlopeTriplet getLowerBound() {
        return this.lowerBound;
    }

    public void setLowerBound(InputOutputSlopeTriplet lowerBound) {
        this.lowerBound = lowerBound;
    }

    public InputOutputSlopeTriplet getUpperBound() {
        return this.upperBound;
    }

    public void setUpperBound(InputOutputSlopeTriplet upperBound) {
        this.upperBound = upperBound;
    }

    public InputOutputSlopeTriplet getOtherPoint() {
        return this.otherPoint;
    }

    public void setOtherPoint(InputOutputSlopeTriplet otherPoint) {
        this.otherPoint = otherPoint;
    }
}

