/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.minimization.line.interpolator;

import gov.sandia.cognition.learning.algorithm.minimization.line.InputOutputSlopeTriplet;
import gov.sandia.cognition.learning.algorithm.minimization.line.LineBracket;
import gov.sandia.cognition.learning.algorithm.minimization.line.interpolator.AbstractLineBracketInterpolatorPolynomial;
import gov.sandia.cognition.learning.function.scalar.PolynomialFunction;
import gov.sandia.cognition.math.DifferentiableUnivariateScalarFunction;

public class LineBracketInterpolatorHermiteCubic
extends AbstractLineBracketInterpolatorPolynomial<DifferentiableUnivariateScalarFunction> {
    public LineBracketInterpolatorHermiteCubic() {
        super(1.0E-6);
    }

    @Override
    public PolynomialFunction.ClosedForm computePolynomial(LineBracket bracket, DifferentiableUnivariateScalarFunction function) {
        InputOutputSlopeTriplet p0 = bracket.getLowerBound();
        InputOutputSlopeTriplet p1 = bracket.getUpperBound();
        if (p0.getSlope() == null) {
            p0.setSlope((Double)function.differentiate(p0.getInput()));
        }
        if (p1.getSlope() == null) {
            p1.setSlope((Double)function.differentiate(p1.getInput()));
        }
        return PolynomialFunction.Cubic.fit(p0, p1);
    }

    @Override
    public boolean hasSufficientPoints(LineBracket bracket) {
        return bracket.getLowerBound() != null && bracket.getUpperBound() != null && !Double.isInfinite((Double)bracket.getLowerBound().getOutput()) && !Double.isInfinite((Double)bracket.getUpperBound().getOutput());
    }
}

