/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.perceptron;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.learning.algorithm.perceptron.AbstractLinearCombinationOnlineLearner;
import gov.sandia.cognition.learning.function.categorization.DefaultKernelBinaryCategorizer;
import gov.sandia.cognition.learning.function.categorization.LinearBinaryCategorizer;
import gov.sandia.cognition.learning.function.kernel.KernelUtil;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFactory;
import gov.sandia.cognition.util.ArgumentChecker;

@PublicationReference(author={"Koby Crammer", "Yoram Singer"}, title="Ultraconservative Online Algorithms for Multiclass Problems", year=2003, type=PublicationType.Journal, publication="Journal of Machine Learning Research", pages={951, 991}, url="http://portal.acm.org/citation.cfm?id=944936")
public class OnlineBinaryMarginInfusedRelaxedAlgorithm
extends AbstractLinearCombinationOnlineLearner {
    public static final boolean DEFAULT_UPDATE_BIAS = false;
    public static final double DEFAULT_MIN_MARGIN = 0.0;
    protected double minMargin;

    public OnlineBinaryMarginInfusedRelaxedAlgorithm() {
        this(0.0);
    }

    public OnlineBinaryMarginInfusedRelaxedAlgorithm(double minMargin) {
        this(minMargin, VectorFactory.getDefault());
    }

    public OnlineBinaryMarginInfusedRelaxedAlgorithm(double minMargin, VectorFactory<?> vectorFactory) {
        super(false, vectorFactory);
        this.setMinMargin(minMargin);
    }

    public double getMinMargin() {
        return this.minMargin;
    }

    public void setMinMargin(double minMargin) {
        ArgumentChecker.assertIsNonNegative((String)"minMargin", (double)minMargin);
        this.minMargin = minMargin;
    }

    @Override
    protected void initialize(LinearBinaryCategorizer target, Vector input, boolean actualCategory) {
        double norm = input.norm2();
        if (norm != 0.0) {
            Vector weights = this.getVectorFactory().copyVector(input);
            double actual = actualCategory ? 1.0 : -1.0;
            weights.scaleEquals(actual / input.norm2());
            target.setWeights(weights);
        }
    }

    @Override
    protected double computeUpdate(LinearBinaryCategorizer target, Vector input, boolean actualCategory, double predicted) {
        double actual = actualCategory ? 1.0 : -1.0;
        double margin = actual * predicted;
        double norm = input.norm2Squared();
        return this.computeUpdate(margin, norm);
    }

    private double computeUpdate(double margin, double norm) {
        if (norm == 0.0) {
            return 0.0;
        }
        if (margin <= this.minMargin && norm != 0.0) {
            return Math.min(-margin / norm, 1.0);
        }
        return 0.0;
    }

    @Override
    protected <InputType> void initialize(DefaultKernelBinaryCategorizer<InputType> target, InputType input, boolean actualCategory) {
        double norm = KernelUtil.norm2(input, target.getKernel());
        if (norm != 0.0) {
            double actual = actualCategory ? 1.0 : -1.0;
            target.add(input, actual / norm);
        }
    }

    @Override
    protected <InputType> double computeUpdate(DefaultKernelBinaryCategorizer<InputType> target, InputType input, boolean actualCategory, double predicted) {
        double norm;
        double actual = actualCategory ? 1.0 : -1.0;
        double margin = actual * predicted;
        if (margin <= this.minMargin && (norm = KernelUtil.norm2Squared(input, target.getKernel())) != 0.0) {
            return Math.min(-margin / norm, 1.0);
        }
        return 0.0;
    }
}

