/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.perceptron.kernel;

import gov.sandia.cognition.learning.algorithm.perceptron.kernel.AbstractOnlineKernelBinaryCategorizerLearner;
import gov.sandia.cognition.learning.function.categorization.DefaultKernelBinaryCategorizer;
import gov.sandia.cognition.learning.function.kernel.Kernel;

public class OnlineKernelPerceptron<InputType>
extends AbstractOnlineKernelBinaryCategorizerLearner<InputType> {
    public OnlineKernelPerceptron() {
        this(null);
    }

    public OnlineKernelPerceptron(Kernel<? super InputType> kernel) {
        this.setKernel(kernel);
    }

    @Override
    public void update(DefaultKernelBinaryCategorizer<InputType> target, InputType input, boolean label) {
        OnlineKernelPerceptron.update(target, input, label, true);
    }

    public static <InputType> boolean update(DefaultKernelBinaryCategorizer<InputType> target, InputType input, boolean label, boolean updateBias) {
        double actual;
        double prediction = target.evaluateAsDouble(input);
        double d = actual = label ? 1.0 : -1.0;
        if (prediction * actual <= 0.0) {
            target.add(input, actual);
            if (updateBias) {
                target.setBias(target.getBias() + actual);
            }
            return true;
        }
        return false;
    }
}

