/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.root;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.evaluator.Evaluator;
import gov.sandia.cognition.learning.algorithm.minimization.line.InputOutputSlopeTriplet;
import gov.sandia.cognition.learning.algorithm.root.AbstractBracketedRootFinder;

@PublicationReference(author={"Wikipedia"}, title="False position method", type=PublicationType.WebPage, year=2009, url="http://en.wikipedia.org/wiki/False_position_method")
public class RootFinderFalsePositionMethod
extends AbstractBracketedRootFinder {
    @Override
    protected boolean step() {
        double delta;
        double xa = (Double)this.getRootBracket().getLowerBound().getInput();
        double fa = (Double)this.getRootBracket().getLowerBound().getOutput();
        double xb = (Double)this.getRootBracket().getUpperBound().getInput();
        double fb = (Double)this.getRootBracket().getUpperBound().getOutput();
        double xsecant = (fb * xa - fa * xb) / (fb - fa);
        double fsecant = (Double)((Evaluator)this.data).evaluate((Object)xsecant);
        InputOutputSlopeTriplet secantRoot = new InputOutputSlopeTriplet(xsecant, fsecant, null);
        this.getRootBracket().setOtherPoint(secantRoot);
        if (fsecant == 0.0) {
            return false;
        }
        if (fa * fsecant > 0.0) {
            delta = xa - xsecant;
            this.getRootBracket().setLowerBound(secantRoot);
        } else {
            delta = xb - xsecant;
            this.getRootBracket().setUpperBound(secantRoot);
        }
        return Math.abs(delta) > this.getTolerance();
    }
}

